/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.BaseCommand;
import org.kitesdk.cli.commands.FlumeConfigCommand;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.hbase.testing.HBaseTestUtils;
import org.kitesdk.data.spi.DefaultConfiguration;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestFlumeConfigurationCommand {
    private Logger console = null;
    private FlumeConfigCommand command;
    private static Configuration original;
    private static String zkQuorum;
    private static String zkPort;
    private static String hdfsHost;
    private static String hdfsPort;
    private static final String DATASET_URI = "dataset:file:target/data/flumeConfig/users";
    private static boolean hdfsIsDefault;

    @BeforeClass
    public static void setConfiguration() throws Exception {
        HBaseTestUtils.getMiniCluster();
        original = DefaultConfiguration.get();
        Configuration conf = HBaseTestUtils.getConf();
        DefaultConfiguration.set((Configuration)conf);
        zkQuorum = conf.get("hbase.zookeeper.quorum");
        zkPort = conf.get("hbase.zookeeper.property.clientPort");
        URI defaultFs = URI.create(conf.get("fs.default.name"));
        hdfsIsDefault = "hdfs".equals(defaultFs.getScheme());
        hdfsHost = defaultFs.getHost();
        hdfsPort = Integer.toString(defaultFs.getPort());
    }

    @AfterClass
    public static void restoreConfiguration() throws Exception {
        DefaultConfiguration.set((Configuration)original);
        HBaseTestUtils.util.shutdownMiniCluster();
    }

    @BeforeClass
    public static void createDataset() throws Exception {
        String avsc = "src/test/resources/test-schemas/user.avsc";
        TestUtil.run("delete", DATASET_URI);
        TestUtil.run("-v", "create", DATASET_URI, "-s", avsc);
    }

    @AfterClass
    public static void deleteDataset() throws Exception {
        TestUtil.run("delete", DATASET_URI);
    }

    @Before
    public void setup() throws Exception {
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new FlumeConfigCommand(this.console);
        this.command.setConf(DefaultConfiguration.get());
    }

    @Test
    public void testHdfsUri() throws Exception {
        Assume.assumeTrue((boolean)hdfsIsDefault);
        URI expected = URI.create("repo:hdfs://" + hdfsHost + ":" + hdfsPort + "/datasets/ns");
        URI actual = this.command.getLegacyRepoUri(URI.create("dataset:hdfs:/datasets/ns/events"), "ns");
        Assert.assertEquals((String)"Unexpected repository URI", (Object)expected, (Object)actual);
    }

    @Test
    public void testFileUri() throws Exception {
        URI expected = URI.create("repo:file:/datasets/ns");
        URI actual = this.command.getLegacyRepoUri(URI.create("dataset:file:/datasets/ns/events"), "ns");
        Assert.assertEquals((String)"Unexpected repository URI", (Object)expected, (Object)actual);
    }

    @Test
    public void testManagedHiveUri() throws Exception {
        URI expected = URI.create("repo:hive");
        URI actual = this.command.getLegacyRepoUri(URI.create("dataset:hive?dataset=events"), "default");
        Assert.assertEquals((String)"Unexpected repository URI", (Object)expected, (Object)actual);
    }

    @Test
    public void testExternalHiveUri() throws Exception {
        Assume.assumeTrue((boolean)hdfsIsDefault);
        URI expected = URI.create("repo:hive:/datasets/ns?hdfs:host=" + hdfsHost + "&hdfs:port=" + hdfsPort);
        URI actual = this.command.getLegacyRepoUri(URI.create("dataset:hive:/datasets/ns/events?namespace=ns&dataset=events"), "ns");
        Assert.assertEquals((String)"Unexpected repository URI", (Object)expected, (Object)actual);
    }

    @Test
    public void testHBaseUri() throws Exception {
        URI expected = URI.create("repo:hbase:" + zkQuorum + ":" + zkPort);
        URI actual = this.command.getLegacyRepoUri(URI.create("dataset:hbase:" + zkQuorum + ":" + zkPort + "/events?namespace=ns"), "ns");
        Assert.assertEquals((String)"Unexpected repository URI", (Object)expected, (Object)actual);
    }

    @Test
    public void testDatasetRequired() throws Exception {
        final FlumeConfigCommand finalCommand = this.command;
        TestHelpers.assertThrows((String)"Throw IllegalArgumentException when no dataset is provided", IllegalArgumentException.class, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return finalCommand.run();
            }
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCheckpointAndDataDirRequired() throws Exception {
        final FlumeConfigCommand finalCommand = this.command;
        finalCommand.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        TestHelpers.assertThrows((String)"Throw IllegalArgumentException when no checkpoint and data dirs are provided", IllegalArgumentException.class, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return finalCommand.run();
            }
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCli() throws Exception {
        int rc = TestUtil.run(this.console, "flume-config", "--checkpoint-dir", "/data/0/flume/checkpoint", "--data-dir", "/data/1/flume/data", DATASET_URI);
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = avro-event-source\ntier1.channels = avro-event-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = avro-event-channel\ntier1.sources.avro-event-source.bind = 0.0.0.0\ntier1.sources.avro-event-source.port = 41415\n\ntier1.channels.avro-event-channel.type = file\ntier1.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.avro-event-channel.dataDirs = /data/1/flume/data\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = avro-event-channel\ntier1.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.kite-dataset.kite.dataset.name = users\ntier1.sinks.kite-dataset.kite.batchSize = 1000\ntier1.sinks.kite-dataset.kite.rollInterval = 30\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCliDataDirs() throws Exception {
        int rc = TestUtil.run(this.console, "flume-config", "--checkpoint-dir", "/data/0/flume/checkpoint", "--data-dir", "/data/1/flume/data", "--data-dir", "/data/2/flume/data", DATASET_URI);
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = avro-event-source\ntier1.channels = avro-event-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = avro-event-channel\ntier1.sources.avro-event-source.bind = 0.0.0.0\ntier1.sources.avro-event-source.port = 41415\n\ntier1.channels.avro-event-channel.type = file\ntier1.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.avro-event-channel.dataDirs = /data/1/flume/data, /data/2/flume/data\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = avro-event-channel\ntier1.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.kite-dataset.kite.dataset.name = users\ntier1.sinks.kite-dataset.kite.batchSize = 1000\ntier1.sinks.kite-dataset.kite.rollInterval = 30\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testDefaults() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.checkpointDir = "/data/0/flume/checkpoint";
        this.command.dataDirs = Lists.newArrayList((Object[])new String[]{"/data/1/flume/data"});
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = avro-event-source\ntier1.channels = avro-event-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = avro-event-channel\ntier1.sources.avro-event-source.bind = 0.0.0.0\ntier1.sources.avro-event-source.port = 41415\n\ntier1.channels.avro-event-channel.type = file\ntier1.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.avro-event-channel.dataDirs = /data/1/flume/data\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = avro-event-channel\ntier1.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.kite-dataset.kite.dataset.name = users\ntier1.sinks.kite-dataset.kite.batchSize = 1000\ntier1.sinks.kite-dataset.kite.rollInterval = 30\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testNewFlume() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.checkpointDir = "/data/0/flume/checkpoint";
        this.command.dataDirs = Lists.newArrayList((Object[])new String[]{"/data/1/flume/data"});
        this.command.newFlume = true;
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = avro-event-source\ntier1.channels = avro-event-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = avro-event-channel\ntier1.sources.avro-event-source.bind = 0.0.0.0\ntier1.sources.avro-event-source.port = 41415\n\ntier1.channels.avro-event-channel.type = file\ntier1.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.avro-event-channel.dataDirs = /data/1/flume/data\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = avro-event-channel\ntier1.sinks.kite-dataset.kite.dataset.uri = dataset:file:target/data/flumeConfig/users\ntier1.sinks.kite-dataset.kite.batchSize = 1000\ntier1.sinks.kite-dataset.kite.rollInterval = 30\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testAgentName() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.checkpointDir = "/data/0/flume/checkpoint";
        this.command.dataDirs = Lists.newArrayList((Object[])new String[]{"/data/1/flume/data"});
        this.command.agent = "agent";
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"agent.sources = avro-event-source\nagent.channels = avro-event-channel\nagent.sinks = kite-dataset\n\nagent.sources.avro-event-source.type = avro\nagent.sources.avro-event-source.channels = avro-event-channel\nagent.sources.avro-event-source.bind = 0.0.0.0\nagent.sources.avro-event-source.port = 41415\n\nagent.channels.avro-event-channel.type = file\nagent.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\nagent.channels.avro-event-channel.dataDirs = /data/1/flume/data\n\nagent.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\nagent.sinks.kite-dataset.channel = avro-event-channel\nagent.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\nagent.sinks.kite-dataset.kite.dataset.name = users\nagent.sinks.kite-dataset.kite.batchSize = 1000\nagent.sinks.kite-dataset.kite.rollInterval = 30\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testSourceName() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.checkpointDir = "/data/0/flume/checkpoint";
        this.command.dataDirs = Lists.newArrayList((Object[])new String[]{"/data/1/flume/data"});
        this.command.sourceName = "my-source";
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = my-source\ntier1.channels = avro-event-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.my-source.type = avro\ntier1.sources.my-source.channels = avro-event-channel\ntier1.sources.my-source.bind = 0.0.0.0\ntier1.sources.my-source.port = 41415\n\ntier1.channels.avro-event-channel.type = file\ntier1.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.avro-event-channel.dataDirs = /data/1/flume/data\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = avro-event-channel\ntier1.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.kite-dataset.kite.dataset.name = users\ntier1.sinks.kite-dataset.kite.batchSize = 1000\ntier1.sinks.kite-dataset.kite.rollInterval = 30\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testChannelName() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.checkpointDir = "/data/0/flume/checkpoint";
        this.command.dataDirs = Lists.newArrayList((Object[])new String[]{"/data/1/flume/data"});
        this.command.channelName = "my-channel";
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = avro-event-source\ntier1.channels = my-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = my-channel\ntier1.sources.avro-event-source.bind = 0.0.0.0\ntier1.sources.avro-event-source.port = 41415\n\ntier1.channels.my-channel.type = file\ntier1.channels.my-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.my-channel.dataDirs = /data/1/flume/data\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = my-channel\ntier1.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.kite-dataset.kite.dataset.name = users\ntier1.sinks.kite-dataset.kite.batchSize = 1000\ntier1.sinks.kite-dataset.kite.rollInterval = 30\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testSinkName() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.checkpointDir = "/data/0/flume/checkpoint";
        this.command.dataDirs = Lists.newArrayList((Object[])new String[]{"/data/1/flume/data"});
        this.command.sinkName = "my-sink";
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = avro-event-source\ntier1.channels = avro-event-channel\ntier1.sinks = my-sink\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = avro-event-channel\ntier1.sources.avro-event-source.bind = 0.0.0.0\ntier1.sources.avro-event-source.port = 41415\n\ntier1.channels.avro-event-channel.type = file\ntier1.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.avro-event-channel.dataDirs = /data/1/flume/data\n\ntier1.sinks.my-sink.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.my-sink.channel = avro-event-channel\ntier1.sinks.my-sink.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.my-sink.kite.dataset.name = users\ntier1.sinks.my-sink.kite.batchSize = 1000\ntier1.sinks.my-sink.kite.rollInterval = 30\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCustomBind() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.checkpointDir = "/data/0/flume/checkpoint";
        this.command.dataDirs = Lists.newArrayList((Object[])new String[]{"/data/1/flume/data"});
        this.command.bindAddress = "127.0.0.1";
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = avro-event-source\ntier1.channels = avro-event-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = avro-event-channel\ntier1.sources.avro-event-source.bind = 127.0.0.1\ntier1.sources.avro-event-source.port = 41415\n\ntier1.channels.avro-event-channel.type = file\ntier1.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.avro-event-channel.dataDirs = /data/1/flume/data\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = avro-event-channel\ntier1.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.kite-dataset.kite.dataset.name = users\ntier1.sinks.kite-dataset.kite.batchSize = 1000\ntier1.sinks.kite-dataset.kite.rollInterval = 30\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCustomPort() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.checkpointDir = "/data/0/flume/checkpoint";
        this.command.dataDirs = Lists.newArrayList((Object[])new String[]{"/data/1/flume/data"});
        this.command.port = 4242;
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = avro-event-source\ntier1.channels = avro-event-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = avro-event-channel\ntier1.sources.avro-event-source.bind = 0.0.0.0\ntier1.sources.avro-event-source.port = 4242\n\ntier1.channels.avro-event-channel.type = file\ntier1.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.avro-event-channel.dataDirs = /data/1/flume/data\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = avro-event-channel\ntier1.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.kite-dataset.kite.dataset.name = users\ntier1.sinks.kite-dataset.kite.batchSize = 1000\ntier1.sinks.kite-dataset.kite.rollInterval = 30\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testDataDirs() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.checkpointDir = "/data/0/flume/checkpoint";
        this.command.dataDirs = Lists.newArrayList((Object[])new String[]{"/data/1/flume/data", "/data/2/flume/data"});
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = avro-event-source\ntier1.channels = avro-event-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = avro-event-channel\ntier1.sources.avro-event-source.bind = 0.0.0.0\ntier1.sources.avro-event-source.port = 41415\n\ntier1.channels.avro-event-channel.type = file\ntier1.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.avro-event-channel.dataDirs = /data/1/flume/data, /data/2/flume/data\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = avro-event-channel\ntier1.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.kite-dataset.kite.dataset.name = users\ntier1.sinks.kite-dataset.kite.batchSize = 1000\ntier1.sinks.kite-dataset.kite.rollInterval = 30\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testMemChannel() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.channelType = "memory";
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = avro-event-source\ntier1.channels = avro-event-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = avro-event-channel\ntier1.sources.avro-event-source.bind = 0.0.0.0\ntier1.sources.avro-event-source.port = 41415\n\ntier1.channels.avro-event-channel.type = memory\ntier1.channels.avro-event-channel.capacity = 10000000\ntier1.channels.avro-event-channel.transactionCapacity = 1000\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = avro-event-channel\ntier1.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.kite-dataset.kite.dataset.name = users\ntier1.sinks.kite-dataset.kite.batchSize = 1000\ntier1.sinks.kite-dataset.kite.rollInterval = 30\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCapacity() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.checkpointDir = "/data/0/flume/checkpoint";
        this.command.dataDirs = Lists.newArrayList((Object[])new String[]{"/data/1/flume/data"});
        this.command.capacity = 42;
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = avro-event-source\ntier1.channels = avro-event-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = avro-event-channel\ntier1.sources.avro-event-source.bind = 0.0.0.0\ntier1.sources.avro-event-source.port = 41415\n\ntier1.channels.avro-event-channel.type = file\ntier1.channels.avro-event-channel.capacity = 42\ntier1.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.avro-event-channel.dataDirs = /data/1/flume/data\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = avro-event-channel\ntier1.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.kite-dataset.kite.dataset.name = users\ntier1.sinks.kite-dataset.kite.batchSize = 1000\ntier1.sinks.kite-dataset.kite.rollInterval = 30\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testTransactionCapacity() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.checkpointDir = "/data/0/flume/checkpoint";
        this.command.dataDirs = Lists.newArrayList((Object[])new String[]{"/data/1/flume/data"});
        this.command.transactionCapacity = 42;
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = avro-event-source\ntier1.channels = avro-event-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = avro-event-channel\ntier1.sources.avro-event-source.bind = 0.0.0.0\ntier1.sources.avro-event-source.port = 41415\n\ntier1.channels.avro-event-channel.type = file\ntier1.channels.avro-event-channel.transactionCapacity = 42\ntier1.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.avro-event-channel.dataDirs = /data/1/flume/data\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = avro-event-channel\ntier1.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.kite-dataset.kite.dataset.name = users\ntier1.sinks.kite-dataset.kite.batchSize = 1000\ntier1.sinks.kite-dataset.kite.rollInterval = 30\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testBatchSize() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.checkpointDir = "/data/0/flume/checkpoint";
        this.command.dataDirs = Lists.newArrayList((Object[])new String[]{"/data/1/flume/data"});
        this.command.batchSize = 42;
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = avro-event-source\ntier1.channels = avro-event-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = avro-event-channel\ntier1.sources.avro-event-source.bind = 0.0.0.0\ntier1.sources.avro-event-source.port = 41415\n\ntier1.channels.avro-event-channel.type = file\ntier1.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.avro-event-channel.dataDirs = /data/1/flume/data\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = avro-event-channel\ntier1.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.kite-dataset.kite.dataset.name = users\ntier1.sinks.kite-dataset.kite.batchSize = 42\ntier1.sinks.kite-dataset.kite.rollInterval = 30\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testRollInterval() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.checkpointDir = "/data/0/flume/checkpoint";
        this.command.dataDirs = Lists.newArrayList((Object[])new String[]{"/data/1/flume/data"});
        this.command.rollInterval = 42;
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = avro-event-source\ntier1.channels = avro-event-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = avro-event-channel\ntier1.sources.avro-event-source.bind = 0.0.0.0\ntier1.sources.avro-event-source.port = 41415\n\ntier1.channels.avro-event-channel.type = file\ntier1.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.avro-event-channel.dataDirs = /data/1/flume/data\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = avro-event-channel\ntier1.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.kite-dataset.kite.dataset.name = users\ntier1.sinks.kite-dataset.kite.batchSize = 1000\ntier1.sinks.kite-dataset.kite.rollInterval = 42\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testProxyUser() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.checkpointDir = "/data/0/flume/checkpoint";
        this.command.dataDirs = Lists.newArrayList((Object[])new String[]{"/data/1/flume/data"});
        this.command.proxyUser = "cloudera";
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"tier1.sources = avro-event-source\ntier1.channels = avro-event-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = avro-event-channel\ntier1.sources.avro-event-source.bind = 0.0.0.0\ntier1.sources.avro-event-source.port = 41415\n\ntier1.channels.avro-event-channel.type = file\ntier1.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.avro-event-channel.dataDirs = /data/1/flume/data\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = avro-event-channel\ntier1.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.kite-dataset.kite.dataset.name = users\ntier1.sinks.kite-dataset.kite.batchSize = 1000\ntier1.sinks.kite-dataset.kite.rollInterval = 30\ntier1.sinks.kite-dataset.auth.proxyUser = cloudera\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testOutputPath() throws Exception {
        String outputPath = "target/flumeConfig/flume.properties";
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{DATASET_URI});
        this.command.checkpointDir = "/data/0/flume/checkpoint";
        this.command.dataDirs = Lists.newArrayList((Object[])new String[]{"/data/1/flume/data"});
        this.command.outputPath = outputPath;
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
        String fileContent = Files.toString((File)new File(outputPath), (Charset)BaseCommand.UTF8);
        TestUtil.assertMatches("tier1.sources = avro-event-source\ntier1.channels = avro-event-channel\ntier1.sinks = kite-dataset\n\ntier1.sources.avro-event-source.type = avro\ntier1.sources.avro-event-source.channels = avro-event-channel\ntier1.sources.avro-event-source.bind = 0.0.0.0\ntier1.sources.avro-event-source.port = 41415\n\ntier1.channels.avro-event-channel.type = file\ntier1.channels.avro-event-channel.checkpointDir = /data/0/flume/checkpoint\n\n# A list of directories where Flume will persist records that are waiting to be\n# processed by the sink. You can use multiple directories on different physical\n# disks to increase throughput.\ntier1.channels.avro-event-channel.dataDirs = /data/1/flume/data\n\ntier1.sinks.kite-dataset.type = org.apache.flume.sink.kite.DatasetSink\ntier1.sinks.kite-dataset.channel = avro-event-channel\ntier1.sinks.kite-dataset.kite.repo.uri = repo:file:.*/target/data/flumeConfig\ntier1.sinks.kite-dataset.kite.dataset.name = users\ntier1.sinks.kite-dataset.kite.batchSize = 1000\ntier1.sinks.kite-dataset.kite.rollInterval = 30\n", fileContent);
    }

    static {
        hdfsIsDefault = false;
    }
}

