/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.BaseCommand;
import org.kitesdk.cli.commands.Log4jConfigCommand;
import org.kitesdk.data.TestHelpers;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestLog4jConfigurationCommand {
    private Logger console = null;
    private Log4jConfigCommand command;
    private static final String FILE_DATASET_URI = "dataset:file:target/data/logConfig/users";
    private static final String HIVE_DATASET_NAME = "users";

    @BeforeClass
    public static void createDatasets() throws Exception {
        String avsc = "resource:test-schemas/user.avsc";
        TestUtil.run("delete", FILE_DATASET_URI);
        TestUtil.run("-v", "create", FILE_DATASET_URI, "-s", avsc);
        TestUtil.run("delete", HIVE_DATASET_NAME);
        TestUtil.run("-v", "create", HIVE_DATASET_NAME, "-s", avsc);
    }

    @AfterClass
    public static void deleteDatasets() throws Exception {
        TestUtil.run("delete", FILE_DATASET_URI);
        TestUtil.run("delete", HIVE_DATASET_NAME);
    }

    @Before
    public void setup() throws Exception {
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new Log4jConfigCommand(this.console);
        this.command.setConf(new Configuration());
    }

    @Test
    public void testCli() throws Exception {
        int rc = TestUtil.run(this.console, new Configuration(), "log4j-config", "--host", "quickstart.cloudera", "--package", "org.kitesdk.test.logging", FILE_DATASET_URI);
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"log4j.appender.flume = org.apache.flume.clients.log4jappender.Log4jAppender\nlog4j.appender.flume.Hostname = quickstart.cloudera\nlog4j.appender.flume.Port = 41415\nlog4j.appender.flume.UnsafeMode = true\nlog4j.appender.flume.AvroSchemaUrl = file:.*/target/data/logConfig/users/.metadata/schemas/1.avsc\n\n# Log events from the following Java class/package:\nlog4j.logger.org.kitesdk.test.logging = INFO, flume\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCliHive() throws Exception {
        int rc = TestUtil.run(this.console, new Configuration(), "log4j-config", "--host", "quickstart.cloudera", "--package", "org.kitesdk.test.logging", HIVE_DATASET_NAME);
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.startsWith((String)"Repository URI:"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"log4j.appender.flume = org.apache.flume.clients.log4jappender.Log4jAppender\nlog4j.appender.flume.Hostname = quickstart.cloudera\nlog4j.appender.flume.Port = 41415\nlog4j.appender.flume.UnsafeMode = true\n\n# Log events from the following Java class/package:\nlog4j.logger.org.kitesdk.test.logging = INFO, flume\n"));
        ((Logger)Mockito.verify((Object)this.console)).warn("Warning: The dataset {} does not have a schema URL. The schema will be sent with each event.", (Object)HIVE_DATASET_NAME);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testDefaults() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{FILE_DATASET_URI});
        this.command.hostname = "quickstart.cloudera";
        this.command.packageName = "org.kitesdk.test.logging";
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"log4j.appender.flume = org.apache.flume.clients.log4jappender.Log4jAppender\nlog4j.appender.flume.Hostname = quickstart.cloudera\nlog4j.appender.flume.Port = 41415\nlog4j.appender.flume.UnsafeMode = true\nlog4j.appender.flume.AvroSchemaUrl = file:.*/target/data/logConfig/users/.metadata/schemas/1.avsc\n\n# Log events from the following Java class/package:\nlog4j.logger.org.kitesdk.test.logging = INFO, flume\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testHiveDataset() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{HIVE_DATASET_NAME});
        this.command.hostname = "quickstart.cloudera";
        this.command.packageName = "org.kitesdk.test.logging";
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.startsWith((String)"Repository URI:"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"log4j.appender.flume = org.apache.flume.clients.log4jappender.Log4jAppender\nlog4j.appender.flume.Hostname = quickstart.cloudera\nlog4j.appender.flume.Port = 41415\nlog4j.appender.flume.UnsafeMode = true\n\n# Log events from the following Java class/package:\nlog4j.logger.org.kitesdk.test.logging = INFO, flume\n"));
        ((Logger)Mockito.verify((Object)this.console)).warn("Warning: The dataset {} does not have a schema URL. The schema will be sent with each event.", (Object)HIVE_DATASET_NAME);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testLogAll() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{FILE_DATASET_URI});
        this.command.hostname = "quickstart.cloudera";
        this.command.logAll = true;
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"# Log events from all classes:\nlog4j.rootLogger = INFO, flume\n\nlog4j.appender.flume = org.apache.flume.clients.log4jappender.Log4jAppender\nlog4j.appender.flume.Hostname = quickstart.cloudera\nlog4j.appender.flume.Port = 41415\nlog4j.appender.flume.UnsafeMode = true\nlog4j.appender.flume.AvroSchemaUrl = file:.*/target/data/logConfig/users/.metadata/schemas/1.avsc\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCustomPort() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{FILE_DATASET_URI});
        this.command.hostname = "quickstart.cloudera";
        this.command.packageName = "org.kitesdk.test.logging";
        this.command.port = 4242;
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.matches((String)"log4j.appender.flume = org.apache.flume.clients.log4jappender.Log4jAppender\nlog4j.appender.flume.Hostname = quickstart.cloudera\nlog4j.appender.flume.Port = 4242\nlog4j.appender.flume.UnsafeMode = true\nlog4j.appender.flume.AvroSchemaUrl = file:.*/target/data/logConfig/users/.metadata/schemas/1.avsc\n\n# Log events from the following Java class/package:\nlog4j.logger.org.kitesdk.test.logging = INFO, flume\n"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testOutputPath() throws Exception {
        String outputPath = "target/logConfig/log4j.properties";
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{FILE_DATASET_URI});
        this.command.hostname = "quickstart.cloudera";
        this.command.packageName = "org.kitesdk.test.logging";
        this.command.outputPath = outputPath;
        int rc = this.command.run();
        Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)rc);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
        String fileContent = Files.toString((File)new File(outputPath), (Charset)BaseCommand.UTF8);
        TestUtil.assertMatches("log4j.appender.flume = org.apache.flume.clients.log4jappender.Log4jAppender\nlog4j.appender.flume.Hostname = quickstart.cloudera\nlog4j.appender.flume.Port = 41415\nlog4j.appender.flume.UnsafeMode = true\nlog4j.appender.flume.AvroSchemaUrl = file:.*/target/data/logConfig/users/.metadata/schemas/1.avsc\n\n# Log events from the following Java class/package:\nlog4j.logger.org.kitesdk.test.logging = INFO, flume\n", fileContent);
    }

    @Test
    public void testDatasetRequired() throws Exception {
        this.command.hostname = "quickstart.cloudera";
        this.command.packageName = "org.kitesdk.test.logging";
        final Log4jConfigCommand finalCommand = this.command;
        TestHelpers.assertThrows((String)"Throw IllegalArgumentException when no dataset is provided", IllegalArgumentException.class, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return finalCommand.run();
            }
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testHostnameRequired() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{FILE_DATASET_URI});
        this.command.packageName = "org.kitesdk.test.logging";
        final Log4jConfigCommand finalCommand = this.command;
        TestHelpers.assertThrows((String)"Throw IllegalArgumentException when no hostname is provided", IllegalArgumentException.class, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return finalCommand.run();
            }
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testPackageNameOrLogAllRequired() throws Exception {
        this.command.datasetName = Lists.newArrayList((Object[])new String[]{FILE_DATASET_URI});
        this.command.hostname = "quickstart.cloudera";
        final Log4jConfigCommand finalCommand = this.command;
        TestHelpers.assertThrows((String)"Throw IllegalArgumentException when package name and log all are not provided", IllegalArgumentException.class, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return finalCommand.run();
            }
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }
}

