/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.SchemaCommand;
import org.kitesdk.data.IncompatibleSchemaException;
import org.kitesdk.data.TestHelpers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestSchemaCommandMerge {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private static Schema userSchema;
    private static Schema userSchemaUpdate;
    private File schemaFile;
    private Logger console = null;
    private SchemaCommand command;

    @BeforeClass
    public static void parseUserSchema() throws Exception {
        userSchema = new Schema.Parser().parse(Resources.getResource((String)"schema/user.avsc").openStream());
        userSchemaUpdate = (Schema)SchemaBuilder.record((String)"user").fields().requiredLong("id").requiredString("username").requiredString("email").endRecord();
    }

    @Before
    public void setup() throws Exception {
        this.schemaFile = this.temp.newFile("user_v2.avsc").getAbsoluteFile();
        Files.write((CharSequence)userSchemaUpdate.toString(), (File)this.schemaFile, (Charset)Charset.forName("utf8"));
        TestUtil.run("create", "users", "--schema", "resource:schema/user.avsc");
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new SchemaCommand(this.console);
        this.command.merge = true;
        this.command.setConf(new Configuration());
    }

    @After
    public void removeDatasets() throws Exception {
        TestUtil.run("delete", "users");
        this.schemaFile.delete();
    }

    @Test
    public void testSingleSchemaDatasetURI() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info((String)Matchers.argThat(TestUtil.matchesSchema(userSchema)));
        ((Logger)Mockito.verify((Object)this.console)).trace(Matchers.contains((String)"repo:hive"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testSingleSchemaResourceURI() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"resource:schema/user.avsc"});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info((String)Matchers.argThat(TestUtil.matchesSchema(userSchema)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testSingleSchemaFile() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{this.schemaFile.toString()});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info((String)Matchers.argThat(TestUtil.matchesSchema(userSchemaUpdate)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testSchemaMerge() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{this.schemaFile.toString(), "resource:schema/user.avsc"});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        Schema merged = (Schema)SchemaBuilder.record((String)"user").fields().optionalLong("id").requiredString("username").requiredString("email").endRecord();
        ((Logger)Mockito.verify((Object)this.console)).info((String)Matchers.argThat(TestUtil.matchesSchema(merged)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testIncompatibleMerge() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"resource:schema/string.avsc", "resource:schema/user.avsc"});
        TestHelpers.assertThrows((String)"Should reject incompatible schemas, not produce a union schema", IncompatibleSchemaException.class, (Callable)new Callable(){

            public Integer call() throws IOException {
                return TestSchemaCommandMerge.this.command.run();
            }
        });
    }
}

