/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.internal.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.TarImportCommand;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestTarImportCommand {
    private Logger console = null;
    private TarImportCommand command;
    private static String datasetUri;
    private static final int NUM_TEST_FILES = 10;
    private static final int MAX_FILENAME_LENGTH = 50;
    private static final int MAX_FILECONTENT_LENGTH = 5000;
    private static final String TEST_DATASET_NAME = "tarimport";
    private static final String TEST_DATASET_DIR = "target/datasets";
    private static final String TEST_DATA_DIR = "target/testdata";
    private static final String TAR_TEST_FILE = "target/testdata/test.tar";
    private static final String TAR_TEST_ROOT_PREFIX = "testnone";
    private static final String TAR_TEST_GZIP_FILE = "target/testdata/test.tar.gz";
    private static final String TAR_TEST_GZIP_ROOT_PREFIX = "testgzip";
    private static final String TAR_TEST_BZIP2_FILE = "target/testdata/test.tar.bz2";
    private static final String TAR_TEST_BZIP2_ROOT_PREFIX = "testbzip2";
    private static final String TAR_TEST_LARGE_ENTRY_FILE = "target/testdata/testlarge.tar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void createTestInputFiles() throws IOException {
        TestTarImportCommand.cleanup();
        Path testData = new Path(TEST_DATA_DIR);
        FileSystem testFS = testData.getFileSystem(new Configuration());
        datasetUri = "dataset:file:" + System.getProperty("user.dir") + "/" + TEST_DATASET_DIR + "/" + TEST_DATASET_NAME;
        TarArchiveOutputStream tosNoCompression = null;
        TarArchiveOutputStream tosGzipCompression = null;
        TarArchiveOutputStream tosBzip2Compression = null;
        TarArchiveOutputStream tosLargeEntry = null;
        Object tarArchiveEntry = null;
        try {
            tosNoCompression = new TarArchiveOutputStream((OutputStream)testFS.create(new Path(TAR_TEST_FILE), true));
            TestTarImportCommand.writeToTarFile(tosNoCompression, "testnone/", null);
            tosGzipCompression = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)testFS.create(new Path(TAR_TEST_GZIP_FILE), true)));
            TestTarImportCommand.writeToTarFile(tosGzipCompression, "testgzip/", null);
            tosBzip2Compression = new TarArchiveOutputStream((OutputStream)new BZip2CompressorOutputStream((OutputStream)testFS.create(new Path(TAR_TEST_BZIP2_FILE), true)));
            TestTarImportCommand.writeToTarFile(tosBzip2Compression, "testbzip2/", null);
            tosLargeEntry = new TarArchiveOutputStream((OutputStream)testFS.create(new Path(TAR_TEST_LARGE_ENTRY_FILE), true));
            String largeEntry = RandomStringUtils.randomAscii((int)10000);
            TestTarImportCommand.writeToTarFile(tosLargeEntry, "largeEntry", largeEntry);
            Random random = new Random(1L);
            for (int i = 0; i < 10; ++i) {
                int fNameLength = random.nextInt(50);
                int fContentLength = random.nextInt(5000);
                String fName = RandomStringUtils.randomAlphanumeric((int)fNameLength);
                String fContent = RandomStringUtils.randomAscii((int)fContentLength);
                TestTarImportCommand.writeToTarFile(tosNoCompression, "testnone/" + fName, fContent);
                TestTarImportCommand.writeToTarFile(tosGzipCompression, "testgzip/" + fName, fContent);
                TestTarImportCommand.writeToTarFile(tosBzip2Compression, "testbzip2/" + fName, fContent);
                System.out.println("Wrote " + fName + " [" + fContentLength + "]");
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(tosNoCompression);
            IOUtils.closeStream(tosGzipCompression);
            IOUtils.closeStream(tosBzip2Compression);
            IOUtils.closeStream(tosLargeEntry);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)tosNoCompression);
        IOUtils.closeStream((Closeable)tosGzipCompression);
        IOUtils.closeStream((Closeable)tosBzip2Compression);
        IOUtils.closeStream((Closeable)tosLargeEntry);
    }

    @AfterClass
    public static void cleanupTests() throws IOException {
        TestTarImportCommand.cleanup();
    }

    private static void cleanup() throws IOException {
        FileUtils.deleteDirectory((File)new File(TEST_DATA_DIR));
        FileUtils.deleteDirectory((File)new File(TEST_DATASET_DIR));
    }

    private static void writeToTarFile(TarArchiveOutputStream tos, String name, String content) throws IOException {
        TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(name);
        if (null != content) {
            tarArchiveEntry.setSize((long)content.length());
        }
        tarArchiveEntry.setModTime(System.currentTimeMillis());
        tos.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
        if (null != content) {
            byte[] buf = content.getBytes();
            tos.write(buf, 0, content.length());
            tos.flush();
        }
        tos.closeArchiveEntry();
    }

    @Test
    public void testTarNoCompressionImportCreateDataset() throws Exception {
        this.removeData();
        this.command.targets = Lists.newArrayList((Object[])new String[]{TAR_TEST_FILE, datasetUri});
        Assert.assertEquals((long)0L, (long)this.command.run());
        ((Logger)Mockito.verify((Object)this.console)).info("Using {} compression", (Object)TarImportCommand.CompressionType.NONE);
        ((Logger)Mockito.verify((Object)this.console)).info("Creating new dataset: {}", (Object)datasetUri);
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)10, (Object)TEST_DATASET_NAME);
    }

    @Test
    public void testTarNoCompressionImportCommand() throws IOException {
        this.command.targets = Lists.newArrayList((Object[])new String[]{TAR_TEST_FILE, datasetUri});
        this.command.compressionType = "none";
        Assert.assertEquals((long)0L, (long)this.command.run());
        ((Logger)Mockito.verify((Object)this.console)).info("Using {} compression", (Object)TarImportCommand.CompressionType.NONE);
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)10, (Object)TEST_DATASET_NAME);
    }

    @Test
    public void testTarNoCompressionImportCommandAutoDetect() throws IOException {
        this.command.targets = Lists.newArrayList((Object[])new String[]{TAR_TEST_FILE, datasetUri});
        Assert.assertEquals((long)0L, (long)this.command.run());
        ((Logger)Mockito.verify((Object)this.console)).info("Using {} compression", (Object)TarImportCommand.CompressionType.NONE);
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)10, (Object)TEST_DATASET_NAME);
    }

    @Test
    public void testTarGzipImportCommand() throws IOException {
        this.command.targets = Lists.newArrayList((Object[])new String[]{TAR_TEST_GZIP_FILE, datasetUri});
        this.command.compressionType = "gzip";
        Assert.assertEquals((long)0L, (long)this.command.run());
        ((Logger)Mockito.verify((Object)this.console)).info("Using {} compression", (Object)TarImportCommand.CompressionType.GZIP);
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)10, (Object)TEST_DATASET_NAME);
    }

    @Test
    public void testTarGzipImportCommandAutoDetect() throws IOException {
        this.command.targets = Lists.newArrayList((Object[])new String[]{TAR_TEST_GZIP_FILE, datasetUri});
        Assert.assertEquals((long)0L, (long)this.command.run());
        ((Logger)Mockito.verify((Object)this.console)).info("Using {} compression", (Object)TarImportCommand.CompressionType.GZIP);
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)10, (Object)TEST_DATASET_NAME);
    }

    @Test
    public void testTarBzip2ImportCommand() throws IOException {
        this.command.targets = Lists.newArrayList((Object[])new String[]{TAR_TEST_BZIP2_FILE, datasetUri});
        this.command.compressionType = "bzip2";
        Assert.assertEquals((long)0L, (long)this.command.run());
        ((Logger)Mockito.verify((Object)this.console)).info("Using {} compression", (Object)TarImportCommand.CompressionType.BZIP2);
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)10, (Object)TEST_DATASET_NAME);
    }

    @Test
    public void testTarBzip2ImportCommandAutoDetect() throws IOException {
        this.command.targets = Lists.newArrayList((Object[])new String[]{TAR_TEST_BZIP2_FILE, datasetUri});
        Assert.assertEquals((long)0L, (long)this.command.run());
        ((Logger)Mockito.verify((Object)this.console)).info("Using {} compression", (Object)TarImportCommand.CompressionType.BZIP2);
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)10, (Object)TEST_DATASET_NAME);
    }

    @Test
    public void testWarnOnLargeEntry() throws IOException {
        this.command.getConf().setLong("dfs.blocksize", 5000L);
        this.command.targets = Lists.newArrayList((Object[])new String[]{TAR_TEST_LARGE_ENTRY_FILE, datasetUri});
        Assert.assertEquals((long)0L, (long)this.command.run());
        ((Logger)Mockito.verify((Object)this.console)).info("Using {} compression", (Object)TarImportCommand.CompressionType.NONE);
        ((Logger)Mockito.verify((Object)this.console)).warn("Entry \"{}\" (size {}) is larger than the HDFS block size of {}. This may result in remote block reads", new Object[]{"largeEntry", 10000L, 5000L});
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)1, (Object)TEST_DATASET_NAME);
    }

    @Before
    public void setup() throws Exception {
        TestUtil.run("-v", "create", datasetUri, "-s", "kite-tools-parent/kite-tools/src/main/avro/tar-import.avsc");
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new TarImportCommand(this.console);
        this.command.setConf(new Configuration());
        this.command.directory = TEST_DATASET_DIR;
        this.command.local = true;
    }

    @After
    public void removeData() throws Exception {
        TestUtil.run("delete", TEST_DATASET_NAME, "--use-local", "-d", TEST_DATASET_DIR);
    }
}

