/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.avro.generic.GenericData;
import org.apache.crunch.PipelineResult;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.data.View;
import org.kitesdk.tools.CompactionTask;
import org.slf4j.Logger;

@Parameters(commandDescription="Compact all or part of a dataset")
public class CompactCommand
extends BaseDatasetCommand {
    @Parameter(description="<dataset-or-view>")
    List<String> datasets;
    @Parameter(names={"--num-writers"}, description="The number of writer processes to use")
    int numWriters = -1;
    @Parameter(names={"--files-per-partition"}, description="The number of files per partition to create")
    int filesPerPartition = -1;

    public CompactCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        PipelineResult result;
        Preconditions.checkArgument((this.datasets.size() == 1 ? 1 : 0) != 0, (Object)"Cannot compact multiple datasets");
        String uriOrName = this.datasets.get(0);
        View<GenericData.Record> view = this.load(uriOrName, GenericData.Record.class);
        if (CompactCommand.isDatasetOrViewUri(uriOrName)) {
            Preconditions.checkArgument((boolean)CompactCommand.viewMatches(view.getUri(), uriOrName), (Object)("Resolved view does not match requested view: " + view.getUri()));
        }
        CompactionTask<GenericData.Record> task = new CompactionTask<GenericData.Record>(view);
        task.setConf(this.getConf());
        if (this.numWriters >= 0) {
            task.setNumWriters(this.numWriters);
        }
        if (this.filesPerPartition > 0) {
            task.setFilesPerPartition(this.filesPerPartition);
        }
        if ((result = task.run()).succeeded()) {
            this.console.info("Compacted {} records in \"{}\"", (Object)task.getCount(), (Object)uriOrName);
            return 0;
        }
        return 1;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Compact the contents of movies", "movies"});
    }
}

