/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.Format;
import org.kitesdk.data.Formats;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.spi.Compatibility;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.Pair;
import org.kitesdk.data.spi.PartitionStrategyParser;
import org.kitesdk.data.spi.Registration;
import org.kitesdk.data.spi.SchemaValidationUtil;
import org.kitesdk.data.spi.Schemas;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;
import org.kitesdk.data.spi.filesystem.FileSystemUtil;
import org.slf4j.Logger;

@Parameters(commandDescription="Create an empty dataset")
public class CreateDatasetCommand
extends BaseDatasetCommand {
    @Parameter(description="<dataset name>")
    List<String> datasets;
    @Parameter(names={"-s", "--schema"}, description="The file containing the Avro schema.")
    String avroSchemaFile;
    @Parameter(names={"-p", "--partition-by"}, description="The file containing a JSON-formatted partition strategy.")
    String partitionStrategyFile;
    @Parameter(names={"-m", "--mapping"}, description="The file containing a JSON-formatted column mapping.")
    String columnMappingFile;
    @Parameter(names={"-f", "--format"}, description="The file format: avro, parquet, or json.")
    String format;
    @Parameter(names={"--location"}, description="Location where the data is stored")
    String location;
    @DynamicParameter(names={"--set", "--property"}, description="Add a property pair: prop.name=value")
    Map<String, String> properties = new HashMap<String, String>();

    public CreateDatasetCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        String name;
        String namespace;
        DatasetRepository repo;
        if (this.datasets == null || this.datasets.size() != 1) {
            throw new IllegalArgumentException("Exactly one dataset name or URI must be specified.");
        }
        String dataset = this.datasets.get(0);
        if (CreateDatasetCommand.isDatasetOrViewUri(dataset)) {
            URI uri = URI.create(URI.create(dataset).getSchemeSpecificPart());
            Pair reg = Registration.lookupDatasetUri((URI)uri);
            repo = (DatasetRepository)reg.first();
            namespace = (String)((Map)reg.second()).get("namespace");
            name = (String)((Map)reg.second()).get("dataset");
            if (this.location == null) {
                this.location = (String)((Map)reg.second()).get("location");
            }
        } else {
            repo = this.getDatasetRepository();
            namespace = "default";
            name = dataset;
        }
        boolean isFileDataset = repo instanceof FileSystemDatasetRepository;
        DatasetDescriptor.Builder descriptorBuilder = new DatasetDescriptor.Builder();
        Path dataPath = null;
        if (this.location != null) {
            dataPath = this.qualifiedPath(this.location);
            descriptorBuilder.location(dataPath);
        } else if (isFileDataset) {
            dataPath = ((FileSystemDatasetRepository)repo).pathForDataset(namespace, name);
        }
        FileSystem fs = isFileDataset ? dataPath.getFileSystem(this.getConf()) : null;
        Format existingFormat = null;
        if (isFileDataset) {
            existingFormat = FileSystemUtil.format((FileSystem)fs, (Path)dataPath);
        }
        if (existingFormat != null) {
            ValidationException.check((this.format == null || Formats.fromString((String)this.format).equals((Object)existingFormat) ? 1 : 0) != 0, (String)"Found %s data, but --format is %s", (Object[])new Object[]{existingFormat.getName(), this.format});
            descriptorBuilder.format(existingFormat);
        } else if (this.format != null) {
            descriptorBuilder.format(this.format);
        }
        Schema existingSchema = null;
        if (isFileDataset) {
            existingSchema = FileSystemUtil.schema((String)"record", (FileSystem)fs, (Path)dataPath);
        }
        Schema schema = existingSchema;
        if (existingSchema != null) {
            if (this.avroSchemaFile != null) {
                schema = Schemas.fromAvsc((InputStream)this.open(this.avroSchemaFile));
                ValidationException.check((boolean)SchemaValidationUtil.canRead((Schema)existingSchema, (Schema)schema), (String)"Schema %s cannot read existing data schema: %s", (Object[])new Object[]{this.avroSchemaFile, existingSchema.toString(true)});
                descriptorBuilder.schemaUri(this.qualifiedURI(this.avroSchemaFile));
            } else {
                descriptorBuilder.schema(existingSchema);
            }
        } else if (this.avroSchemaFile != null) {
            descriptorBuilder.schemaUri(this.qualifiedURI(this.avroSchemaFile));
        } else {
            throw new ValidationException("Schema is missing: use --schema");
        }
        PartitionStrategy existingStrategy = null;
        if (isFileDataset && existingSchema != null) {
            existingStrategy = FileSystemUtil.strategy((FileSystem)fs, (Path)dataPath);
        }
        if (existingStrategy != null) {
            if (this.partitionStrategyFile != null) {
                PartitionStrategy strategy = PartitionStrategyParser.parse((InputStream)this.open(this.partitionStrategyFile));
                Compatibility.checkStrategyUpdate((PartitionStrategy)existingStrategy, (PartitionStrategy)strategy, (Schema)schema);
                descriptorBuilder.partitionStrategy(strategy);
            } else {
                descriptorBuilder.partitionStrategy(existingStrategy);
            }
        } else if (this.partitionStrategyFile != null) {
            descriptorBuilder.partitionStrategyUri(this.qualifiedURI(this.partitionStrategyFile));
        }
        if (this.columnMappingFile != null) {
            descriptorBuilder.columnMappingUri(this.qualifiedURI(this.columnMappingFile));
        }
        if (this.properties != null) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                descriptorBuilder.property(entry.getKey(), entry.getValue());
            }
        }
        repo.create(namespace, name, descriptorBuilder.build());
        this.console.debug("Created {}", (Object)dataset);
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Create dataset \"users\" in Hive:", "users --schema user.avsc", "# Create HDFS dataset \"users\":", "dataset:hdfs:/user/me/datasets/users --schema user.avsc", "# Create dataset \"users\" using parquet:", "users --schema user.avsc --format parquet", "# Create dataset \"users\" partitioned by JSON configuration:", "users --schema user.avsc --partition-by email-part.json", "# Create HBase dataset \"users\":", "dataset:hbase:zk1,zk2/users --schema user.avsc \\\n\t\t--partition-by email-part.json --mapping user-cols.json"});
    }
}

