/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.slf4j.Logger;

@Parameters(commandDescription="Build a log4j config to log events to a dataset")
public class Log4jConfigCommand
extends BaseDatasetCommand {
    @Parameter(description="Dataset name or URI", required=true)
    List<String> datasetName;
    @Parameter(names={"--host"}, description="Flume hostname", required=true)
    String hostname;
    @Parameter(names={"--port"}, description="Flume port")
    int port = 41415;
    @Parameter(names={"--class", "--package"}, description="Java class/package to log from")
    String packageName;
    @Parameter(names={"--log-all"}, description="Configure the root logger to send to Flume")
    boolean logAll;
    @Parameter(names={"-o", "--output"}, description="Save logging config to path")
    @SuppressWarnings(value={"UWF_NULL_FIELD"}, justification="Field set by JCommander")
    String outputPath = null;

    public Log4jConfigCommand(Logger console) {
        super(console);
    }

    @Override
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="Null case checked by precondition")
    public int run() throws IOException {
        Preconditions.checkArgument((this.datasetName != null && !this.datasetName.isEmpty() ? 1 : 0) != 0, (Object)"Missing dataset uri");
        Preconditions.checkArgument((this.hostname != null ? 1 : 0) != 0, (Object)"Missing Flume hostname");
        Preconditions.checkArgument((this.packageName != null || this.logAll ? 1 : 0) != 0, (Object)"Must provide a class/package name or specify --log-all");
        URL schemaUrl = this.load(this.datasetName.get(0), GenericRecord.class).getDataset().getDescriptor().getSchemaUrl();
        if (schemaUrl == null) {
            this.console.warn("Warning: The dataset {} does not have a schema URL. The schema will be sent with each event.", (Object)this.datasetName.get(0));
        }
        StringBuilder sb = new StringBuilder();
        if (this.logAll) {
            sb.append("# Log events from all classes:\n");
            sb.append("log4j.rootLogger = INFO, flume\n");
            sb.append("\n");
        }
        sb.append("log4j.appender.flume = org.apache.flume.clients.log4jappender.Log4jAppender\n");
        sb.append("log4j.appender.flume.Hostname = ").append(this.hostname).append("\n");
        sb.append("log4j.appender.flume.Port = ").append(this.port).append("\n");
        sb.append("log4j.appender.flume.UnsafeMode = true").append("\n");
        if (schemaUrl != null) {
            sb.append("log4j.appender.flume.AvroSchemaUrl = ").append(schemaUrl).append("\n");
        }
        if (this.packageName != null) {
            sb.append("\n");
            sb.append("# Log events from the following Java class/package:\n");
            sb.append("log4j.logger.").append(this.packageName).append(" = INFO, flume\n");
        }
        this.output(sb.toString(), this.console, this.outputPath);
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Print log4j configuration to log to dataset \"users\":", "--host flume.cluster.com --class org.kitesdk.examples.MyLoggingApp users", "# Save log4j configuration to the file \"log4j.properties\":", "--host flume.cluster.com --package org.kitesdk.examples -o log4j.properties users", "# Print log4j configuration to log from all classes:", "--host flume.cluster.com --log-all users"});
    }
}

