/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.dropwizard.consul;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.SubstitutingSourceProvider;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import io.dropwizard.servlets.tasks.Task;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.text.StringSubstitutor;
import org.kiwiproject.consul.Consul;
import org.kiwiproject.consul.ConsulException;
import org.kiwiproject.dropwizard.consul.ConsulConfiguration;
import org.kiwiproject.dropwizard.consul.ConsulFactory;
import org.kiwiproject.dropwizard.consul.config.ConsulSubstitutor;
import org.kiwiproject.dropwizard.consul.core.ConsulAdvertiser;
import org.kiwiproject.dropwizard.consul.core.ConsulServiceListener;
import org.kiwiproject.dropwizard.consul.health.ConsulHealthCheck;
import org.kiwiproject.dropwizard.consul.managed.ConsulAdvertiserManager;
import org.kiwiproject.dropwizard.consul.task.MaintenanceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConsulBundle<C extends Configuration>
implements ConfiguredBundle<C>,
ConsulConfiguration<C> {
    private static final Logger LOG = LoggerFactory.getLogger(ConsulBundle.class);
    private static final String CONSUL_AUTH_HEADER_KEY = "X-Consul-Token";
    private final String defaultServiceName;
    private final boolean strict;
    private final boolean substitutionInVariables;
    private final AtomicBoolean initializeAttempted;
    private final AtomicBoolean initializeSucceeded;

    public ConsulBundle(String name) {
        this(name, false);
    }

    public ConsulBundle(String name, boolean strict) {
        this(name, strict, false);
    }

    public ConsulBundle(String name, boolean strict, boolean substitutionInVariables) {
        this.defaultServiceName = Objects.requireNonNull(name);
        this.strict = strict;
        this.substitutionInVariables = substitutionInVariables;
        this.initializeAttempted = new AtomicBoolean();
        this.initializeSucceeded = new AtomicBoolean();
    }

    public void initialize(Bootstrap<?> bootstrap) {
        this.initializeAttempted.set(true);
        String consulAgentHost = this.getConsulAgentHost();
        int consulAgentPort = this.getConsulAgentPort();
        try {
            LOG.debug("Connecting to Consul at {}:{}", (Object)consulAgentHost, (Object)consulAgentPort);
            Consul.Builder consulBuilder = Consul.builder().withHostAndPort(HostAndPort.fromParts((String)consulAgentHost, (int)consulAgentPort));
            this.getConsulAclToken().ifPresent(token -> {
                LOG.debug("Using Consul ACL token from configuration (value intentionally not shown)");
                consulBuilder.withAclToken(token).withHeaders(Map.of(CONSUL_AUTH_HEADER_KEY, token));
            });
            Consul consul = consulBuilder.build();
            bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new SubstitutingSourceProvider(bootstrap.getConfigurationSourceProvider(), (StringSubstitutor)new ConsulSubstitutor(consul, this.strict, this.substitutionInVariables)));
            LOG.info("ConsulBundle successfully initialized");
            this.initializeSucceeded.set(true);
        }
        catch (ConsulException e) {
            this.initializeSucceeded.set(false);
            LOG.warn("Unable to query Consul at {}:{}, so cannot perform configuration substitution from Consul KV (enable DEBUG to see stack trace)", (Object)consulAgentHost, (Object)consulAgentPort);
            LOG.debug("Stack trace for failure to connect to Consul at {}:{}", new Object[]{consulAgentHost, consulAgentPort, e});
        }
    }

    public void run(C configuration, Environment environment) {
        ConsulFactory consulFactory = this.getConsulFactory((Configuration)configuration);
        if (consulFactory.isEnabled()) {
            this.runEnabled(consulFactory, environment);
        } else {
            LOG.warn("Consul bundle disabled.");
        }
    }

    protected void runEnabled(ConsulFactory consulFactory, Environment environment) {
        if (Strings.isNullOrEmpty((String)consulFactory.getServiceName())) {
            consulFactory.setServiceName(this.defaultServiceName);
        }
        this.setupEnvironment(consulFactory, environment);
    }

    protected void setupEnvironment(ConsulFactory consulFactory, Environment environment) {
        Consul consul = consulFactory.build();
        String serviceId = consulFactory.getServiceId().orElseGet(() -> UUID.randomUUID().toString());
        ConsulAdvertiser advertiser = new ConsulAdvertiser(environment, consulFactory, consul, serviceId);
        Optional<Duration> retryInterval = consulFactory.getRetryInterval();
        Optional<ScheduledExecutorService> scheduler = retryInterval.map(i -> Executors.newScheduledThreadPool(1));
        environment.lifecycle().addServerLifecycleListener((ServerLifecycleListener)new ConsulServiceListener(advertiser, retryInterval, scheduler));
        environment.healthChecks().register("consul", (HealthCheck)new ConsulHealthCheck(consul));
        environment.lifecycle().manage((Managed)new ConsulAdvertiserManager(advertiser, scheduler));
        environment.admin().addTask((Task)new MaintenanceTask(consul, serviceId));
    }

    @VisibleForTesting
    public String getConsulAgentHost() {
        return "localhost";
    }

    @VisibleForTesting
    public int getConsulAgentPort() {
        return 8500;
    }

    @VisibleForTesting
    public Optional<String> getConsulAclToken() {
        return Optional.empty();
    }

    public boolean didAttemptInitialize() {
        return this.initializeAttempted.get();
    }

    public boolean didInitializeSucceed() {
        return this.initializeSucceeded.get();
    }
}

