/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.dropwizard.consul;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.validation.constraints.NotNull;
import org.apache.commons.net.util.SubnetUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.consul.Consul;
import org.kiwiproject.consul.config.ClientConfig;

public class ConsulFactory {
    private static final String CONSUL_AUTH_HEADER_KEY = "X-Consul-Token";
    @NotNull
    private HostAndPort endpoint = HostAndPort.fromParts((String)"localhost", (int)8500);
    private @Nullable String serviceName;
    private boolean enabled = true;
    private Optional<String> serviceId = Optional.empty();
    private Optional<Integer> servicePort = Optional.empty();
    private Optional<Integer> adminPort = Optional.empty();
    private Optional<String> serviceAddress = Optional.empty();
    private Optional<String> serviceSubnet = Optional.empty();
    private Optional<Supplier<String>> serviceAddressSupplier = Optional.empty();
    private Optional<Iterable<String>> tags = Optional.empty();
    private Optional<String> aclToken = Optional.empty();
    private Optional<Map<String, String>> serviceMeta = Optional.empty();
    private boolean servicePing = true;
    @MinDuration(value=1L, unit=TimeUnit.SECONDS)
    private @Nullable @MinDuration(value=1L, unit=TimeUnit.SECONDS) Duration retryInterval;
    @NotNull
    @MinDuration(value=1L, unit=TimeUnit.SECONDS)
    private @NotNull @MinDuration(value=1L, unit=TimeUnit.SECONDS) Duration checkInterval = Duration.seconds((long)1L);
    @NotNull
    @MinDuration(value=1L, unit=TimeUnit.MINUTES)
    private @NotNull @MinDuration(value=1L, unit=TimeUnit.MINUTES) Duration deregisterInterval = Duration.minutes((long)1L);
    private Optional<String> healthCheckPath = Optional.empty();
    private Optional<Long> networkWriteTimeoutMillis = Optional.empty();
    private Optional<Long> networkReadTimeoutMillis = Optional.empty();
    private Optional<ClientConfig> clientConfig = Optional.empty();

    @JsonProperty
    public boolean isEnabled() {
        return this.enabled;
    }

    @JsonProperty
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @JsonProperty
    public HostAndPort getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty
    public void setEndpoint(HostAndPort endpoint) {
        this.endpoint = endpoint;
    }

    @JsonProperty
    public Optional<String> getServiceId() {
        return this.serviceId;
    }

    @JsonProperty
    public void setServiceId(@Nullable String serviceId) {
        this.serviceId = Optional.ofNullable(serviceId);
    }

    @JsonProperty
    public @Nullable String getServiceName() {
        return this.serviceName;
    }

    @JsonProperty
    public void setServiceName(@Nullable String serviceName) {
        this.serviceName = serviceName;
    }

    @JsonProperty
    public Optional<Iterable<String>> getTags() {
        return this.tags;
    }

    @JsonProperty
    public void setTags(Iterable<String> tags) {
        this.tags = Optional.ofNullable(tags);
    }

    @JsonProperty
    public Optional<Integer> getServicePort() {
        return this.servicePort;
    }

    @JsonProperty
    public void setServicePort(Integer servicePort) {
        this.servicePort = Optional.ofNullable(servicePort);
    }

    @JsonProperty
    public Optional<Integer> getAdminPort() {
        return this.adminPort;
    }

    @JsonProperty
    public void setAdminPort(Integer adminPort) {
        this.adminPort = Optional.ofNullable(adminPort);
    }

    @JsonProperty
    public Optional<String> getServiceAddress() {
        return this.serviceAddress;
    }

    @JsonProperty
    public void setServiceAddress(String serviceAddress) {
        this.serviceAddress = Optional.ofNullable(serviceAddress);
    }

    @JsonProperty
    public Optional<Duration> getRetryInterval() {
        return Optional.ofNullable(this.retryInterval);
    }

    @JsonProperty
    public void setRetryInterval(@Nullable Duration interval) {
        this.retryInterval = interval;
    }

    @JsonProperty
    public Duration getCheckInterval() {
        return this.checkInterval;
    }

    @JsonProperty
    public void setCheckInterval(Duration interval) {
        this.checkInterval = interval;
    }

    @JsonProperty
    public Duration getDeregisterInterval() {
        return this.deregisterInterval;
    }

    @JsonProperty
    public void setDeregisterInterval(Duration interval) {
        this.deregisterInterval = interval;
    }

    @JsonProperty
    public Optional<String> getAclToken() {
        return this.aclToken;
    }

    @JsonProperty
    public void setAclToken(@Nullable String aclToken) {
        this.aclToken = Optional.ofNullable(aclToken);
    }

    @JsonProperty
    public Optional<Map<String, String>> getServiceMeta() {
        return this.serviceMeta;
    }

    @JsonProperty
    public void setServiceMeta(Map<String, String> serviceMeta) {
        this.serviceMeta = Optional.ofNullable(serviceMeta);
    }

    @JsonProperty
    public boolean isServicePing() {
        return this.servicePing;
    }

    @JsonProperty
    public void setServicePing(boolean servicePing) {
        this.servicePing = servicePing;
    }

    public Optional<String> getServiceSubnet() {
        return this.serviceSubnet;
    }

    public void setServiceSubnet(String serviceSubnet) {
        Preconditions.checkArgument((boolean)ConsulFactory.isValidCidrIp(serviceSubnet), (String)"%s is not a valid Subnet in CIDR notation", (Object)serviceSubnet);
        this.serviceSubnet = Optional.ofNullable(serviceSubnet);
    }

    public void setServiceAddressSupplier(Supplier<String> serviceAddressSupplier) {
        this.serviceAddressSupplier = Optional.ofNullable(serviceAddressSupplier);
    }

    public Optional<Supplier<String>> getServiceAddressSupplier() {
        return this.serviceAddressSupplier;
    }

    public Optional<String> getHealthCheckPath() {
        return this.healthCheckPath;
    }

    public void setHealthCheckPath(String healthCheckPath) {
        this.healthCheckPath = Optional.ofNullable(healthCheckPath);
    }

    public Optional<Long> getNetworkWriteTimeoutMillis() {
        return this.networkWriteTimeoutMillis;
    }

    public void setNetworkWriteTimeoutMillis(Long networkTimeout) {
        this.networkWriteTimeoutMillis = Optional.ofNullable(networkTimeout);
    }

    public Optional<Long> getNetworkReadTimeoutMillis() {
        return this.networkReadTimeoutMillis;
    }

    public void setNetworkReadTimeoutMillis(Long networkReadTimeoutMillis) {
        this.networkReadTimeoutMillis = Optional.ofNullable(networkReadTimeoutMillis);
    }

    public Optional<ClientConfig> getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = Optional.ofNullable(clientConfig);
    }

    @JsonIgnore
    public Consul build() {
        Consul.Builder consulBuilder = Consul.builder().withHostAndPort(this.endpoint).withPing(this.servicePing);
        this.aclToken.ifPresent(token -> consulBuilder.withAclToken(token).withHeaders(Map.of(CONSUL_AUTH_HEADER_KEY, token)));
        this.networkWriteTimeoutMillis.ifPresent(arg_0 -> ((Consul.Builder)consulBuilder).withWriteTimeoutMillis(arg_0));
        this.networkReadTimeoutMillis.ifPresent(arg_0 -> ((Consul.Builder)consulBuilder).withReadTimeoutMillis(arg_0));
        this.clientConfig.ifPresent(arg_0 -> ((Consul.Builder)consulBuilder).withClientConfiguration(arg_0));
        return consulBuilder.build();
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.serviceName, this.enabled, this.servicePort, this.adminPort, this.serviceAddress, this.tags, this.retryInterval, this.checkInterval, this.deregisterInterval, this.aclToken, this.serviceMeta, this.servicePing);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (Objects.isNull(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        ConsulFactory other = (ConsulFactory)obj;
        return Objects.equals(this.endpoint, other.endpoint) && Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.servicePort, other.servicePort) && Objects.equals(this.adminPort, other.adminPort) && Objects.equals(this.serviceAddress, other.serviceAddress) && Objects.equals(this.tags, other.tags) && Objects.equals(this.retryInterval, other.retryInterval) && Objects.equals(this.checkInterval, other.checkInterval) && Objects.equals(this.deregisterInterval, other.deregisterInterval) && Objects.equals(this.aclToken, other.aclToken) && Objects.equals(this.serviceMeta, other.serviceMeta) && Objects.equals(this.servicePing, other.servicePing);
    }

    private static boolean isValidCidrIp(String cidrIp) {
        boolean isValid = true;
        try {
            new SubnetUtils(cidrIp);
        }
        catch (IllegalArgumentException e) {
            isValid = false;
        }
        return isValid;
    }
}

