/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.dropwizard.consul.health;

import com.codahale.metrics.health.HealthCheck;
import java.util.Objects;
import org.kiwiproject.consul.Consul;
import org.kiwiproject.consul.ConsulException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulHealthCheck
extends HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ConsulHealthCheck.class);
    private final Consul consul;

    public ConsulHealthCheck(Consul consul) {
        this.consul = Objects.requireNonNull(consul);
    }

    protected HealthCheck.Result check() {
        try {
            this.consul.agentClient().ping();
            return HealthCheck.Result.healthy();
        }
        catch (ConsulException e) {
            LOG.warn("Unable to ping consul", (Throwable)e);
            return HealthCheck.Result.unhealthy((String)"Could not ping consul");
        }
    }
}

