/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.dropwizard.consul.task;

import io.dropwizard.servlets.tasks.Task;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.kiwiproject.consul.Consul;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintenanceTask
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(MaintenanceTask.class);
    private final Consul consul;
    private final String serviceId;

    public MaintenanceTask(Consul consul, String serviceId) {
        super("maintenance");
        this.consul = Objects.requireNonNull(consul);
        this.serviceId = Objects.requireNonNull(serviceId);
    }

    public void execute(Map<String, List<String>> parameters, PrintWriter output) {
        if (!parameters.containsKey("enable")) {
            throw new IllegalArgumentException("Parameter \"enable\" not found");
        }
        List reasons = parameters.getOrDefault("reason", List.of());
        String reason = reasons.stream().filter(Objects::nonNull).findFirst().orElse("");
        boolean enable = Boolean.parseBoolean(parameters.get("enable").get(0));
        String action = enable ? "Enabling" : "Disabling";
        String reasonForLogs = reason.isEmpty() ? "none given" : reason;
        LOG.warn("{} maintenance mode for service {} (reason: {})", new Object[]{action, this.serviceId, reasonForLogs});
        this.consul.agentClient().toggleMaintenanceMode(this.serviceId, enable, reason);
        output.println("OK");
        output.flush();
    }
}

