/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.dropwizard.consul.core;

import io.dropwizard.lifecycle.ServerLifecycleListener;
import io.dropwizard.util.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.kiwiproject.consul.ConsulException;
import org.kiwiproject.dropwizard.consul.core.ConsulAdvertiser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulServiceListener
implements ServerLifecycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(ConsulServiceListener.class);
    private static final String APPLICATION_NAME = "application";
    private static final String ADMIN_NAME = "admin";
    private final ConsulAdvertiser advertiser;
    private final Optional<Duration> retryInterval;
    private final Optional<ScheduledExecutorService> scheduler;

    public ConsulServiceListener(ConsulAdvertiser advertiser, Optional<Duration> retryInterval, Optional<ScheduledExecutorService> scheduler) {
        this.advertiser = Objects.requireNonNull(advertiser, "advertiser == null");
        this.retryInterval = Objects.requireNonNull(retryInterval, "retryInterval == null");
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler == null");
    }

    public void serverStarted(Server server) {
        String applicationScheme = null;
        int applicationPort = -1;
        int adminPort = -1;
        HashSet<String> hosts = new HashSet<String>();
        for (Connector connector : server.getConnectors()) {
            ServerConnector serverConnector = (ServerConnector)connector;
            hosts.add(serverConnector.getHost());
            if (APPLICATION_NAME.equals(connector.getName())) {
                applicationPort = serverConnector.getLocalPort();
                applicationScheme = ConsulServiceListener.getScheme(connector.getProtocols());
                continue;
            }
            if (ADMIN_NAME.equals(connector.getName())) {
                adminPort = serverConnector.getLocalPort();
                continue;
            }
            applicationPort = serverConnector.getLocalPort();
            applicationScheme = ConsulServiceListener.getScheme(connector.getProtocols());
            adminPort = applicationPort;
        }
        LOG.debug("applicationScheme: {}, applicationPort: {}, adminPort: {}", new Object[]{applicationScheme, applicationPort, adminPort});
        this.register(applicationScheme, applicationPort, adminPort, hosts);
    }

    private static String getScheme(List<String> protocols) {
        if (protocols.contains("ssl")) {
            return "https";
        }
        return "http";
    }

    void register(String applicationScheme, int applicationPort, int adminPort, Collection<String> hosts) {
        try {
            this.advertiser.register(applicationScheme, applicationPort, adminPort, hosts);
            this.scheduler.ifPresent(ExecutorService::shutdownNow);
        }
        catch (ConsulException e) {
            LOG.error("Failed to register service in Consul", (Throwable)e);
            this.retryInterval.ifPresent(interval -> this.scheduler.ifPresent(service -> {
                LOG.info("Will try to register service again in {} seconds", (Object)interval.toSeconds());
                service.schedule(() -> this.register(applicationScheme, applicationPort, adminPort, hosts), interval.toSeconds(), TimeUnit.SECONDS);
            }));
        }
    }
}

