/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.dropwizard.consul.core;

import io.dropwizard.core.setup.Environment;
import jakarta.ws.rs.core.UriBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.commons.net.util.SubnetUtils;
import org.kiwiproject.consul.AgentClient;
import org.kiwiproject.consul.Consul;
import org.kiwiproject.consul.ConsulException;
import org.kiwiproject.consul.model.agent.ImmutableRegCheck;
import org.kiwiproject.consul.model.agent.ImmutableRegistration;
import org.kiwiproject.consul.model.agent.Registration;
import org.kiwiproject.dropwizard.consul.ConsulFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulAdvertiser {
    private static final Logger LOG = LoggerFactory.getLogger(ConsulAdvertiser.class);
    private static final String LOCALHOST = "127.0.0.1";
    private static final String DEFAULT_HEALTH_CHECK_PATH = "healthcheck";
    private final AtomicReference<Integer> servicePort = new AtomicReference();
    private final AtomicReference<Integer> serviceAdminPort = new AtomicReference();
    private final AtomicReference<String> serviceAddress = new AtomicReference();
    private final AtomicReference<String> serviceSubnet = new AtomicReference();
    private final AtomicReference<Supplier<String>> serviceAddressSupplier = new AtomicReference();
    private final AtomicReference<String> aclToken = new AtomicReference();
    private final AtomicReference<Iterable<String>> tags = new AtomicReference();
    private final AtomicReference<Map<String, String>> serviceMeta = new AtomicReference();
    private final Environment environment;
    private final ConsulFactory configuration;
    private final Consul consul;
    private final String serviceId;
    private final AtomicReference<String> healthCheckPath = new AtomicReference();

    public ConsulAdvertiser(Environment environment, ConsulFactory configuration, Consul consul, String serviceId) {
        this.environment = Objects.requireNonNull(environment, "environment == null");
        this.configuration = Objects.requireNonNull(configuration, "configuration == null");
        this.consul = Objects.requireNonNull(consul, "consul == null");
        this.serviceId = Objects.requireNonNull(serviceId, "serviceId == null");
        configuration.getServicePort().ifPresent(port -> {
            LOG.info("Using \"{}\" as servicePort from configuration file", port);
            this.servicePort.set((Integer)port);
        });
        configuration.getAdminPort().ifPresent(port -> {
            LOG.info("Using \"{}\" as adminPort from configuration file", port);
            this.serviceAdminPort.set((Integer)port);
        });
        configuration.getServiceAddress().ifPresent(address -> {
            LOG.info("Using \"{}\" as serviceAddress from configuration file", address);
            this.serviceAddress.set((String)address);
        });
        configuration.getServiceSubnet().ifPresent(subnet -> {
            LOG.info("Using \"{}\" as serviceSubnet from configuration file", subnet);
            this.serviceSubnet.set((String)subnet);
        });
        configuration.getServiceAddressSupplier().ifPresent(supplier -> {
            LOG.info("Using \"{}\" as serviceSupplier from configuration file", supplier);
            this.serviceAddressSupplier.set((Supplier<String>)supplier);
        });
        configuration.getTags().ifPresent(newTags -> {
            LOG.info("Using \"{}\" as tags from the configuration file", newTags);
            this.tags.set((Iterable<String>)newTags);
        });
        configuration.getAclToken().ifPresent(token -> {
            LOG.info("Using ACL token from the configuration file (value intentionally not shown)");
            this.aclToken.set((String)token);
        });
        configuration.getServiceMeta().ifPresent(newServiceMeta -> {
            LOG.info("Using \"{}\" as serviceMeta from the configuration file", newServiceMeta);
            this.serviceMeta.set((Map<String, String>)newServiceMeta);
        });
        configuration.getHealthCheckPath().ifPresent(newHealthCheckPath -> {
            LOG.info("Using \"{}\" as health check path from the configuration file", newHealthCheckPath);
            this.healthCheckPath.set((String)newHealthCheckPath);
        });
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public boolean register(String applicationScheme, int applicationPort, int adminPort) {
        return this.register(applicationScheme, applicationPort, adminPort, null);
    }

    public boolean register(String applicationScheme, int applicationPort, int adminPort, Collection<String> ipAddresses) {
        AgentClient agentClient = this.consul.agentClient();
        if (agentClient.isRegistered(this.serviceId)) {
            LOG.info("Service ({}) [{}] already registered", (Object)this.configuration.getServiceName(), (Object)this.serviceId);
            return false;
        }
        this.servicePort.compareAndSet(null, applicationPort);
        this.serviceAdminPort.compareAndSet(null, adminPort);
        this.healthCheckPath.compareAndSet(null, DEFAULT_HEALTH_CHECK_PATH);
        LOG.info("Registering service ({}) [{}] on port {} (admin port {}) with a health check at {} with interval of {}s", new Object[]{this.configuration.getServiceName(), this.serviceId, this.servicePort.get(), this.serviceAdminPort.get(), this.healthCheckPath.get(), this.configuration.getCheckInterval().toSeconds()});
        ImmutableRegCheck registrationCheck = ImmutableRegCheck.builder().http(this.getHealthCheckUrl(applicationScheme, ipAddresses)).interval(String.format("%ds", this.configuration.getCheckInterval().toSeconds())).deregisterCriticalServiceAfter(String.format("%dm", this.configuration.getDeregisterInterval().toMinutes())).build();
        ImmutableRegistration.Builder registrationBuilder = ImmutableRegistration.builder().port(this.servicePort.get().intValue()).check((Registration.RegCheck)registrationCheck).id(this.serviceId);
        String serviceName = this.configuration.getServiceName();
        if (Objects.nonNull(serviceName)) {
            registrationBuilder.name(serviceName);
        }
        this.getServiceAddress(ipAddresses).ifPresent(arg_0 -> ((ImmutableRegistration.Builder)registrationBuilder).address(arg_0));
        if (Objects.nonNull(this.tags.get())) {
            registrationBuilder.tags(this.tags.get());
        }
        if (Objects.nonNull(this.serviceMeta.get())) {
            registrationBuilder.meta(this.serviceMeta.get());
        }
        registrationBuilder.putMeta("scheme", applicationScheme);
        agentClient.register((Registration)registrationBuilder.build());
        return true;
    }

    private Optional<String> getServiceAddress(Collection<String> ipAddresses) {
        Optional<String> ip;
        if (Objects.nonNull(this.serviceAddress.get())) {
            return Optional.of(this.serviceAddress.get());
        }
        if (Objects.nonNull(ipAddresses) && !ipAddresses.isEmpty() && Objects.nonNull(this.serviceSubnet.get()) && (ip = this.findFirstEligibleIpBySubnet(ipAddresses)).isPresent()) {
            return ip;
        }
        if (Objects.nonNull(this.serviceAddressSupplier.get())) {
            try {
                return Optional.ofNullable(this.serviceAddressSupplier.get().get());
            }
            catch (Exception ex) {
                LOG.debug("Service address supplier threw an exception.", (Throwable)ex);
            }
        }
        return Optional.empty();
    }

    private Optional<String> findFirstEligibleIpBySubnet(Collection<String> ipAddresses) {
        SubnetUtils subnetUtils = new SubnetUtils(this.serviceSubnet.get());
        SubnetUtils.SubnetInfo subNetInfo = subnetUtils.getInfo();
        return ipAddresses.stream().filter(arg_0 -> ((SubnetUtils.SubnetInfo)subNetInfo).isInRange(arg_0)).findFirst();
    }

    public void deregister() {
        AgentClient agentClient = this.consul.agentClient();
        try {
            if (!agentClient.isRegistered(this.serviceId)) {
                LOG.info("No service registered with ID \"{}\"", (Object)this.serviceId);
                return;
            }
        }
        catch (ConsulException e) {
            LOG.error("Failed to determine if service ID \"{}\" is registered", (Object)this.serviceId, (Object)e);
            return;
        }
        LOG.info("Deregistering service ID \"{}\"", (Object)this.serviceId);
        try {
            agentClient.deregister(this.serviceId);
        }
        catch (ConsulException e) {
            LOG.error("Failed to deregister service from Consul", (Throwable)e);
        }
    }

    protected String getHealthCheckUrl(String applicationScheme, Collection<String> hosts) {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.environment.getAdminContext().getContextPath()).path(this.healthCheckPath.get()).scheme(applicationScheme).host(this.getServiceAddress(hosts).orElse(LOCALHOST)).port(this.serviceAdminPort.get().intValue());
        return uriBuilder.build(new Object[0]).toString();
    }
}

