/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.dropwizard.consul.config;

import io.dropwizard.configuration.UndefinedEnvironmentVariableException;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.text.lookup.StringLookup;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.consul.Consul;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulLookup
implements StringLookup {
    private static final Logger LOG = LoggerFactory.getLogger(ConsulLookup.class);
    private final boolean strict;
    private final Consul consul;

    public ConsulLookup(Consul consul) {
        this(consul, true);
    }

    public ConsulLookup(Consul consul, boolean strict) {
        this.consul = Objects.requireNonNull(consul);
        this.strict = strict;
    }

    public @Nullable String lookup(String key) {
        try {
            Optional value = this.consul.keyValueClient().getValueAsString(key);
            if (value.isPresent()) {
                return (String)value.get();
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to lookup key in consul", (Throwable)e);
        }
        if (this.strict) {
            throw new UndefinedEnvironmentVariableException(String.format("The variable with key '%s' is not found in the Consul KV store; could not substitute the expression '${%s}'.", key, key));
        }
        return null;
    }
}

