/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.curator.leader;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.curator.leader.ManagedLeaderLatch;
import org.kiwiproject.curator.leader.ServiceDescriptor;
import org.kiwiproject.curator.leader.exception.ManagedLeaderLatchException;
import org.kiwiproject.curator.leader.health.ManagedLeaderLatchHealthCheck;
import org.kiwiproject.curator.leader.resource.GotLeaderLatchResource;
import org.kiwiproject.curator.leader.resource.LeaderResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedLeaderLatchCreator {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(ManagedLeaderLatchCreator.class);
    private final CuratorFramework client;
    private final Environment environment;
    private final ServiceDescriptor serviceDescriptor;
    private final List<LeaderLatchListener> listeners;
    private ManagedLeaderLatch leaderLatch;
    private boolean addHealthCheck;
    private ManagedLeaderLatchHealthCheck healthCheck;
    private boolean addResources;

    private ManagedLeaderLatchCreator(CuratorFramework client, Environment environment, ServiceDescriptor serviceDescriptor, List<LeaderLatchListener> listeners) {
        this.client = (CuratorFramework)KiwiPreconditions.requireNotNull((Object)client);
        Preconditions.checkState((client.getState() == CuratorFrameworkState.STARTED ? 1 : 0) != 0, (Object)"CuratorFramework must be started");
        this.environment = (Environment)KiwiPreconditions.requireNotNull((Object)environment);
        this.serviceDescriptor = (ServiceDescriptor)KiwiPreconditions.requireNotNull((Object)serviceDescriptor);
        this.listeners = (List)KiwiPreconditions.requireNotNull(listeners);
        this.addHealthCheck = true;
        this.addResources = true;
    }

    public static ManagedLeaderLatchCreator from(CuratorFramework client, Environment environment, ServiceDescriptor serviceDescriptor, LeaderLatchListener ... listeners) {
        return new ManagedLeaderLatchCreator(client, environment, serviceDescriptor, Lists.newArrayList((Object[])listeners));
    }

    public static ManagedLeaderLatch startLeaderLatch(CuratorFramework client, Environment environment, ServiceDescriptor serviceDescriptor, LeaderLatchListener ... listeners) {
        ManagedLeaderLatchCreator leaderLatchCreator = ManagedLeaderLatchCreator.start(client, environment, serviceDescriptor, listeners);
        return leaderLatchCreator.getLeaderLatch();
    }

    public static ManagedLeaderLatchCreator start(CuratorFramework client, Environment environment, ServiceDescriptor serviceInfo, LeaderLatchListener ... listeners) {
        return ManagedLeaderLatchCreator.from(client, environment, serviceInfo, listeners).start();
    }

    public ManagedLeaderLatchCreator withoutHealthCheck() {
        this.addHealthCheck = false;
        return this;
    }

    public ManagedLeaderLatchCreator withoutResources() {
        this.addResources = false;
        return this;
    }

    public ManagedLeaderLatchCreator addLeaderLatchListener(LeaderLatchListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public ManagedLeaderLatchCreator start() {
        if (Objects.nonNull(this.leaderLatch)) {
            LOG.warn("start() has already been called. Ignoring this invocation.");
            return this;
        }
        LeaderLatchListener[] listenerArray = this.listeners.toArray(new LeaderLatchListener[0]);
        this.leaderLatch = new ManagedLeaderLatch(this.client, this.serviceDescriptor, listenerArray);
        this.environment.lifecycle().manage((Managed)this.leaderLatch);
        this.startLatchOrThrow();
        this.addHealthCheckIfConfigured();
        this.addResourcesIfConfigured();
        return this;
    }

    private void startLatchOrThrow() {
        try {
            this.leaderLatch.start();
        }
        catch (Exception e) {
            throw new ManagedLeaderLatchException("Error starting leader latch", e);
        }
    }

    private void addHealthCheckIfConfigured() {
        if (this.addHealthCheck) {
            this.healthCheck = new ManagedLeaderLatchHealthCheck(this.leaderLatch);
            this.environment.healthChecks().register("leaderLatch", (HealthCheck)this.healthCheck);
        }
    }

    private void addResourcesIfConfigured() {
        if (this.addResources) {
            this.environment.jersey().register((Object)new GotLeaderLatchResource());
            this.environment.jersey().register((Object)new LeaderResource(this.leaderLatch));
        }
    }

    public ManagedLeaderLatch getLeaderLatch() {
        this.validateStarted();
        return this.leaderLatch;
    }

    public Optional<ManagedLeaderLatchHealthCheck> getHealthCheck() {
        this.validateStarted();
        return Optional.ofNullable(this.healthCheck);
    }

    public List<LeaderLatchListener> getListeners() {
        this.validateStarted();
        return List.copyOf(this.listeners);
    }

    private void validateStarted() {
        Preconditions.checkState((boolean)Objects.nonNull(this.leaderLatch), (Object)"Leader latch is not started; call start() first");
    }
}

