/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.curator.leader.health;

import com.codahale.metrics.health.HealthCheck;
import java.util.Collection;
import java.util.List;
import org.apache.curator.framework.recipes.leader.Participant;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.curator.leader.ManagedLeaderLatch;
import org.kiwiproject.metrics.health.HealthCheckResults;
import org.kiwiproject.metrics.health.HealthStatus;

public class ManagedLeaderLatchHealthCheck
extends HealthCheck {
    private static final String LEADER_DETAIL_NAME = "leader";
    private static final String PARTICIPANTS_DETAIL_NAME = "participants";
    private final ManagedLeaderLatch leaderLatch;

    public ManagedLeaderLatchHealthCheck(ManagedLeaderLatch leaderLatch) {
        this.leaderLatch = leaderLatch;
    }

    protected HealthCheck.Result check() {
        if (!this.leaderLatch.isStarted()) {
            return HealthCheckResults.newUnhealthyResultBuilder((HealthStatus)HealthStatus.CRITICAL).withMessage("Leader latch state (%s) is not started", new Object[]{this.leaderLatch.getLatchState()}).withDetail(LEADER_DETAIL_NAME, (Object)false).withDetail(PARTICIPANTS_DETAIL_NAME, List.of()).build();
        }
        Collection<Participant> participants = this.leaderLatch.getParticipants();
        List<String> leaderIds = ManagedLeaderLatchHealthCheck.leaderIdsOf(participants);
        if (KiwiLists.isNullOrEmpty(leaderIds)) {
            return HealthCheckResults.newUnhealthyResultBuilder((HealthStatus)HealthStatus.CRITICAL).withMessage("There are NO leaders for latch path %s", new Object[]{this.leaderLatch.getLatchPath()}).withDetail(LEADER_DETAIL_NAME, (Object)false).withDetail(PARTICIPANTS_DETAIL_NAME, ManagedLeaderLatchHealthCheck.idsOf(participants)).build();
        }
        if (leaderIds.size() > 1) {
            return HealthCheckResults.newUnhealthyResultBuilder((HealthStatus)HealthStatus.CRITICAL).withMessage("There is more than one leader for latch path %s. Leader IDs: %s (this latch ID: %s)", new Object[]{this.leaderLatch.getLatchPath(), leaderIds, this.leaderLatch.getId()}).withDetail(LEADER_DETAIL_NAME, (Object)this.leaderLatch.hasLeadership()).withDetail(PARTICIPANTS_DETAIL_NAME, ManagedLeaderLatchHealthCheck.idsOf(participants)).build();
        }
        return HealthCheckResults.newHealthyResultBuilder().withMessage("Leader latch is started (has leadership? %s)", new Object[]{this.leaderLatch.hasLeadership()}).withDetail(LEADER_DETAIL_NAME, (Object)this.leaderLatch.hasLeadership()).withDetail(PARTICIPANTS_DETAIL_NAME, ManagedLeaderLatchHealthCheck.idsOf(participants)).build();
    }

    private static List<String> leaderIdsOf(Collection<Participant> participants) {
        return participants.stream().filter(Participant::isLeader).map(Participant::getId).toList();
    }

    private static List<String> idsOf(Collection<Participant> participants) {
        return participants.stream().map(Participant::getId).toList();
    }
}

