/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.curator.leader.resource;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.kiwiproject.curator.leader.ManagedLeaderLatch;

@Path(value="/kiwi/leader-latch")
@Produces(value={"application/json"})
public class LeaderResource {
    private final ManagedLeaderLatch leaderLatch;

    public LeaderResource(ManagedLeaderLatch leaderLatch) {
        this.leaderLatch = leaderLatch;
    }

    @GET
    @Path(value="/leader")
    public Response hasLeadership() {
        Map<String, Boolean> entity = Map.of("leader", this.leaderLatch.hasLeadership());
        return Response.ok(entity).build();
    }

    @GET
    @Path(value="/latch")
    public Response getLatchState() {
        Map<String, LeaderLatch.State> entity = Map.of("id", this.leaderLatch.getId(), "leader", this.leaderLatch.hasLeadership(), "latchPath", this.leaderLatch.getLatchPath(), "participants", this.leaderLatch.getParticipants(), "state", this.leaderLatch.getLatchState());
        return Response.ok(entity).build();
    }
}

