/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.curator.leader;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.errorprone.annotations.CheckReturnValue;
import io.dropwizard.lifecycle.Managed;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.curator.leader.LeadershipStatus;
import org.kiwiproject.curator.leader.ServiceDescriptor;
import org.kiwiproject.curator.leader.exception.ManagedLeaderLatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedLeaderLatch
implements Managed {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(ManagedLeaderLatch.class);
    private static final String ROOT_ZNODE_PATH = "/kiwi/leader-latch";
    private final String id;
    private final String latchPath;
    private final LeaderLatch leaderLatch;
    private final CuratorFramework client;
    private final AtomicBoolean started;

    public ManagedLeaderLatch(CuratorFramework client, ServiceDescriptor serviceDescriptor, LeaderLatchListener ... listeners) {
        this(client, ManagedLeaderLatch.leaderLatchId(serviceDescriptor), serviceDescriptor.getName(), listeners);
    }

    public ManagedLeaderLatch(CuratorFramework client, String id, String serviceName, LeaderLatchListener ... listeners) {
        this(client, id, ManagedLeaderLatch.newLatch(client, id, serviceName), listeners);
    }

    @VisibleForTesting
    ManagedLeaderLatch(CuratorFramework client, String id, LatchAndPath latchAndPath, LeaderLatchListener ... listeners) {
        this.client = (CuratorFramework)KiwiPreconditions.requireNotNull((Object)client, (String)"client must not be null", (Object[])new Object[0]);
        this.id = KiwiPreconditions.requireNotBlank((String)id, (String)"id must not be blank");
        this.latchPath = latchAndPath.latchPath();
        this.leaderLatch = latchAndPath.latch();
        Arrays.stream(Objects.requireNonNull(listeners)).forEach(arg_0 -> ((LeaderLatch)this.leaderLatch).addListener(arg_0));
        this.started = new AtomicBoolean();
    }

    private static LatchAndPath newLatch(CuratorFramework client, String id, String serviceName) {
        String latchPath = ManagedLeaderLatch.leaderLatchPath(KiwiPreconditions.requireNotBlank((String)serviceName, (String)"serviceName must not be blank"));
        LeaderLatch leaderLatch = new LeaderLatch(client, latchPath, id, LeaderLatch.CloseMode.NOTIFY_LEADER);
        return new LatchAndPath(leaderLatch, latchPath);
    }

    public static String leaderLatchId(ServiceDescriptor serviceDescriptor) {
        KiwiPreconditions.checkArgumentNotNull((Object)serviceDescriptor, (String)"serviceDescriptor must not be null");
        return ManagedLeaderLatch.leaderLatchId(serviceDescriptor.getName(), serviceDescriptor.getVersion(), serviceDescriptor.getHostname(), serviceDescriptor.getPort());
    }

    public static String leaderLatchId(String serviceName, String serviceVersion, String hostname, int port) {
        return KiwiStrings.f((String)"{}/{}/{}:{}", (Object[])new Object[]{serviceName, serviceVersion, hostname, port});
    }

    public static String leaderLatchPath(String serviceName) {
        return Paths.get(ROOT_ZNODE_PATH, serviceName, "leader-latch").toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("latchPath", (Object)this.latchPath).add("started", this.started.get()).toString();
    }

    public void start() throws Exception {
        Verify.verify((this.client.getState() == CuratorFrameworkState.STARTED ? 1 : 0) != 0, (String)"CuratorFramework must be started", (Object[])new Object[0]);
        if (this.started.compareAndSet(false, true)) {
            this.ensurePathsExistAndStartLatch();
        } else {
            LOG.trace("start() has already been called. Ignoring request to start");
        }
    }

    private void ensurePathsExistAndStartLatch() throws Exception {
        LOG.trace("Checking latch path {}", (Object)this.latchPath);
        Stat possiblyNullStat = this.checkPathExists(this.latchPath);
        Stat lockPathStat = Optional.ofNullable(possiblyNullStat).orElseGet(this::createLeaderLatchNode);
        LOG.info("Path [{}] creation time: {}", (Object)this.latchPath, (Object)ZonedDateTime.ofInstant(Instant.ofEpochMilli(lockPathStat.getCtime()), ZoneOffset.UTC));
        LOG.trace("Starting leader latch {}", (Object)this.id);
        this.leaderLatch.start();
    }

    private Stat createLeaderLatchNode() {
        try {
            LOG.info("Path {} does not exist. Creating it.", (Object)this.latchPath);
            String path = (String)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(this.latchPath);
            Preconditions.checkState((boolean)path.equals(this.latchPath), (String)"Created path %s does not match expected path %s", (Object)path, (Object)this.latchPath);
            return this.checkPathExists(path);
        }
        catch (Exception e) {
            throw new ManagedLeaderLatchException("Unable to create latch path: " + this.latchPath, e);
        }
    }

    private Stat checkPathExists(String path) throws Exception {
        return (Stat)this.client.checkExists().forPath(path);
    }

    public void stop() {
        LOG.trace("Stopping leader latch {}", (Object)this.id);
        try {
            this.leaderLatch.close();
        }
        catch (Exception e) {
            LOG.error("Error closing leader latch {}", (Object)this.id, (Object)e);
        }
    }

    public LeaderLatch getManagedLatch() {
        return this.leaderLatch;
    }

    @CheckReturnValue
    public boolean hasLeadershipIgnoringErrors() {
        return this.leaderLatch.hasLeadership();
    }

    @CheckReturnValue
    public LeadershipStatus checkLeadershipStatus() {
        try {
            if (this.client.getState() != CuratorFrameworkState.STARTED) {
                return new LeadershipStatus.CuratorNotStarted(this.client.getState());
            }
            if (!this.isStarted()) {
                return new LeadershipStatus.LatchNotStarted(this.getLatchState());
            }
            if (this.getParticipants().isEmpty()) {
                return new LeadershipStatus.NoLatchParticipants();
            }
            return this.leaderLatch.hasLeadership() ? new LeadershipStatus.IsLeader() : new LeadershipStatus.NotLeader();
        }
        catch (Exception e) {
            return new LeadershipStatus.OtherError(e);
        }
    }

    @CheckReturnValue
    public boolean hasLeadership() {
        if (this.client.getState() != CuratorFrameworkState.STARTED) {
            this.logAndThrowLatchException("Curator must be started and not closed before calling this method. Curator state: " + this.client.getState());
        }
        if (!this.isStarted()) {
            this.logAndThrowLatchException("LeaderLatch must be started and not closed before calling this method. Latch state: " + this.leaderLatch.getState());
        }
        if (this.getParticipants().isEmpty()) {
            this.logAndThrowLatchException("LeaderLatch must have participants before calling this method.");
        }
        boolean isLeader = this.leaderLatch.hasLeadership();
        LOG.trace("hasLeadership? {}", (Object)isLeader);
        return isLeader;
    }

    @CheckReturnValue
    public boolean doesNotHaveLeadership() {
        return !this.hasLeadership();
    }

    private void logAndThrowLatchException(String msg) {
        ManagedLeaderLatchException exception = new ManagedLeaderLatchException(msg);
        LOG.warn(msg);
        LOG.debug("Stack trace: ", (Throwable)exception);
        throw exception;
    }

    public Collection<Participant> getParticipants() {
        try {
            return this.leaderLatch.getParticipants();
        }
        catch (Exception e) {
            throw new ManagedLeaderLatchException(e);
        }
    }

    public Participant getLeader() {
        try {
            return this.leaderLatch.getLeader();
        }
        catch (Exception e) {
            throw new ManagedLeaderLatchException(e);
        }
    }

    public boolean isStarted() {
        return this.leaderLatch.getState() == LeaderLatch.State.STARTED;
    }

    public boolean isClosed() {
        return this.leaderLatch.getState() == LeaderLatch.State.CLOSED;
    }

    public LeaderLatch.State getLatchState() {
        return this.leaderLatch.getState();
    }

    public void whenLeader(Runnable action) {
        if (this.hasLeadership()) {
            action.run();
        }
    }

    public Optional<CompletableFuture<Void>> whenLeaderAsync(Runnable action) {
        if (this.hasLeadership()) {
            return Optional.of(CompletableFuture.runAsync(action));
        }
        return Optional.empty();
    }

    public <T> Optional<T> whenLeader(Supplier<T> resultSupplier) {
        if (this.hasLeadership()) {
            return Optional.of(resultSupplier.get());
        }
        return Optional.empty();
    }

    public <T> Optional<CompletableFuture<T>> whenLeaderAsync(Supplier<T> resultSupplier) {
        if (this.hasLeadership()) {
            return Optional.of(CompletableFuture.supplyAsync(resultSupplier));
        }
        return Optional.empty();
    }

    public <T> Optional<CompletableFuture<T>> whenLeaderAsync(Supplier<T> resultSupplier, Executor executor) {
        if (this.hasLeadership()) {
            return Optional.of(CompletableFuture.supplyAsync(resultSupplier, executor));
        }
        return Optional.empty();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getLatchPath() {
        return this.latchPath;
    }

    @VisibleForTesting
    record LatchAndPath(LeaderLatch latch, String latchPath) {
        LatchAndPath {
            KiwiPreconditions.checkArgumentNotNull((Object)latch, (String)"latch must not be null");
            KiwiPreconditions.checkArgumentNotBlank((String)latchPath, (String)"latchPath must not be blank");
        }
    }
}

