/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.curator.leader.health;

import com.codahale.metrics.health.HealthCheck;
import java.util.Collection;
import java.util.List;
import org.apache.curator.framework.recipes.leader.Participant;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.curator.leader.ManagedLeaderLatch;
import org.kiwiproject.metrics.health.HealthCheckResults;
import org.kiwiproject.metrics.health.HealthStatus;

public class ManagedLeaderLatchHealthCheck
extends HealthCheck {
    private static final String LEADER_DETAIL_NAME = "leader";
    private static final String LEADER_PARTICIPANT_DETAIL_NAME = "leaderParticipant";
    private static final String THIS_PARTICIPANT_DETAIL_NAME = "thisParticipant";
    private static final String PARTICIPANTS_DETAIL_NAME = "participants";
    private final ManagedLeaderLatch leaderLatch;

    public ManagedLeaderLatchHealthCheck(ManagedLeaderLatch leaderLatch) {
        this.leaderLatch = leaderLatch;
    }

    protected HealthCheck.Result check() {
        String participantId = this.leaderLatch.getId();
        if (!this.leaderLatch.isStarted()) {
            return HealthCheckResults.newUnhealthyResultBuilder((HealthStatus)HealthStatus.CRITICAL).withMessage("Leader latch state (%s) is not started", new Object[]{this.leaderLatch.getLatchState()}).withDetail(LEADER_DETAIL_NAME, (Object)false).withDetail(LEADER_PARTICIPANT_DETAIL_NAME, null).withDetail(THIS_PARTICIPANT_DETAIL_NAME, (Object)participantId).withDetail(PARTICIPANTS_DETAIL_NAME, List.of()).build();
        }
        Collection<Participant> participants = this.leaderLatch.getParticipants();
        List<String> leaderIds = ManagedLeaderLatchHealthCheck.leaderIdsOf(participants);
        List<String> participantIds = ManagedLeaderLatchHealthCheck.idsOf(participants);
        if (KiwiLists.isNullOrEmpty(leaderIds)) {
            return HealthCheckResults.newUnhealthyResultBuilder((HealthStatus)HealthStatus.CRITICAL).withMessage("There are NO leaders for latch path %s", new Object[]{this.leaderLatch.getLatchPath()}).withDetail(LEADER_DETAIL_NAME, (Object)false).withDetail(LEADER_PARTICIPANT_DETAIL_NAME, null).withDetail(THIS_PARTICIPANT_DETAIL_NAME, (Object)participantId).withDetail(PARTICIPANTS_DETAIL_NAME, participantIds).build();
        }
        if (leaderIds.size() > 1) {
            return HealthCheckResults.newUnhealthyResultBuilder((HealthStatus)HealthStatus.CRITICAL).withMessage("There is more than one leader for latch path %s. Leader IDs: %s (this latch ID: %s)", new Object[]{this.leaderLatch.getLatchPath(), leaderIds, this.leaderLatch.getId()}).withDetail(LEADER_DETAIL_NAME, (Object)this.leaderLatch.hasLeadership()).withDetail(LEADER_PARTICIPANT_DETAIL_NAME, KiwiLists.first(leaderIds)).withDetail(THIS_PARTICIPANT_DETAIL_NAME, (Object)participantId).withDetail(PARTICIPANTS_DETAIL_NAME, participantIds).build();
        }
        return HealthCheckResults.newHealthyResultBuilder().withMessage("Leader latch is started (has leadership? %s)", new Object[]{this.leaderLatch.hasLeadership()}).withDetail(LEADER_DETAIL_NAME, (Object)this.leaderLatch.hasLeadership()).withDetail(LEADER_PARTICIPANT_DETAIL_NAME, KiwiLists.first(leaderIds)).withDetail(THIS_PARTICIPANT_DETAIL_NAME, (Object)participantId).withDetail(PARTICIPANTS_DETAIL_NAME, participantIds).build();
    }

    private static List<String> leaderIdsOf(Collection<Participant> participants) {
        return participants.stream().filter(Participant::isLeader).map(Participant::getId).toList();
    }

    private static List<String> idsOf(Collection<Participant> participants) {
        return participants.stream().map(Participant::getId).toList();
    }
}

