/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.curator.leader;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.kiwiproject.base.KiwiPreconditions;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface LeadershipStatus {
    default public boolean isValidStatus() {
        return !this.isErrorStatus();
    }

    public boolean isErrorStatus();

    public record OtherError(Exception error) implements ErrorLeadershipStatus
    {
        public OtherError {
            KiwiPreconditions.checkArgumentNotNull((Object)error, (String)"error must not be null");
        }
    }

    public record NoLatchParticipants() implements ErrorLeadershipStatus
    {
    }

    public record LatchNotStarted(LeaderLatch.State latchState) implements ErrorLeadershipStatus
    {
        public LatchNotStarted {
            Preconditions.checkArgument((Objects.nonNull(latchState) && latchState != LeaderLatch.State.STARTED ? 1 : 0) != 0, (Object)"latchState must not be null or STARTED");
        }
    }

    public record CuratorNotStarted(CuratorFrameworkState curatorState) implements ErrorLeadershipStatus
    {
        public CuratorNotStarted {
            Preconditions.checkArgument((Objects.nonNull(curatorState) && curatorState != CuratorFrameworkState.STARTED ? 1 : 0) != 0, (Object)"curatorState must not be null or STARTED");
        }
    }

    public record NotLeader() implements ValidLeadershipStatus
    {
    }

    public record IsLeader() implements ValidLeadershipStatus
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ErrorLeadershipStatus
    extends LeadershipStatus {
        @Override
        default public boolean isErrorStatus() {
            return true;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ValidLeadershipStatus
    extends LeadershipStatus {
        @Override
        default public boolean isErrorStatus() {
            return false;
        }
    }
}

