/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.elucidation.common.definition;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kiwiproject.elucidation.common.model.ConnectionEvent;
import org.kiwiproject.elucidation.common.model.Direction;

public interface CommunicationDefinition {
    public String getCommunicationType();

    public boolean isDependentEvent(ConnectionEvent var1);

    public static Map<String, CommunicationDefinition> toMap(List<CommunicationDefinition> definitions) {
        return definitions.stream().collect(Collectors.toUnmodifiableMap(CommunicationDefinition::getCommunicationType, def -> def));
    }

    public static CommunicationDefinition forDependentDirection(final String communicationType, final Direction dependentEventDirection) {
        return new CommunicationDefinition(){

            @Override
            public String getCommunicationType() {
                return communicationType;
            }

            @Override
            public boolean isDependentEvent(ConnectionEvent event) {
                return dependentEventDirection == event.getEventDirection();
            }
        };
    }
}

