/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base;

import com.google.common.annotations.Beta;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.base.CatchingRunnable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.beta.base.CatchingRunnable2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class KiwiRunnables {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(KiwiRunnables.class);

    public static void runAllQuietly(ThrowingRunnable ... runnables) {
        Arrays.stream(runnables).forEach(KiwiRunnables::runQuietly);
    }

    public static void runQuietly(ThrowingRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            LOG.warn("Suppressed exception:", (Throwable)e);
        }
    }

    public static List<RunResult> runAll(ThrowingRunnable ... runnables) {
        return Arrays.stream(runnables).map(KiwiRunnables::run).collect(Collectors.toUnmodifiableList());
    }

    public static RunResult run(ThrowingRunnable runnable) {
        try {
            runnable.run();
            return RunResult.ofSuccess();
        }
        catch (Exception e) {
            return RunResult.ofError(e);
        }
    }

    @Generated
    private KiwiRunnables() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class RunResult {
        private @Nullable Exception error;

        public static RunResult ofSuccess() {
            return new RunResult(null);
        }

        public static RunResult ofError(Exception exception) {
            KiwiPreconditions.checkArgumentNotNull((Object)exception);
            return new RunResult(exception);
        }

        public boolean success() {
            return Objects.isNull(this.error);
        }

        public boolean hasError() {
            return Objects.nonNull(this.error);
        }

        @Generated
        public @Nullable Exception error() {
            return this.error;
        }

        @ConstructorProperties(value={"error"})
        @Generated
        private RunResult(@Nullable Exception error) {
            this.error = error;
        }
    }

    public static class WrappedException
    extends RuntimeException {
        public WrappedException(Throwable cause) {
            super("Contains Exception thrown by a wrapped ThrowingRunnable", cause);
        }
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Exception;

        public static ThrowingRunnable of(Runnable runnable) {
            return runnable::run;
        }

        default public Runnable toRunnable() {
            ThrowingRunnable outer = this;
            return () -> {
                try {
                    outer.run();
                }
                catch (Exception e) {
                    throw new WrappedException(e);
                }
            };
        }

        default public CatchingRunnable toCatchingRunnable() {
            ThrowingRunnable outer = this;
            return () -> {
                try {
                    outer.run();
                }
                catch (Exception e) {
                    throw new WrappedException(e);
                }
            };
        }

        default public CatchingRunnable2 toCatchingRunnable2() {
            return CatchingRunnable2.of(this.toRunnable());
        }
    }
}

