/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base;

import com.google.common.annotations.Beta;
import com.google.common.base.CaseFormat;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
public final class KiwiStrings2 {
    private static final Pattern NULL_CHAR_PATTERN = Pattern.compile("\u0000");

    public static String camelToSnakeCase(String value) {
        return KiwiStrings2.camelToSnakeCaseOrEmpty(value).orElseThrow(() -> new IllegalArgumentException("value must not be blank"));
    }

    public static Optional<String> camelToSnakeCaseOrEmpty(@Nullable String value) {
        return Optional.ofNullable(KiwiStrings2.camelToSnakeCaseOrNull(value));
    }

    public static String camelToSnakeCaseOrNull(@Nullable String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return (String)CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE).convert((Object)value);
    }

    public static String replaceNullCharactersWithEmpty(@Nullable String str) {
        return KiwiStrings2.replaceNullCharacters(str, "", null);
    }

    public static String replaceNullCharacters(@Nullable String str, String replacement, @Nullable String defaultValue) {
        return Optional.ofNullable(str).map(s -> NULL_CHAR_PATTERN.matcher((CharSequence)s).replaceAll(replacement)).orElse(defaultValue);
    }

    @Generated
    private KiwiStrings2() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

