/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.reflect;

import com.google.common.annotations.Beta;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import lombok.Generated;

@Beta
public final class KiwiReflection2 {
    public static boolean hasAccessModifier(Member member, JavaAccessModifier modifier) {
        switch (modifier) {
            case PUBLIC: {
                return KiwiReflection2.isPublic(member);
            }
            case PROTECTED: {
                return KiwiReflection2.isProtected(member);
            }
            case PRIVATE: {
                return KiwiReflection2.isPrivate(member);
            }
            case PACKAGE_PRIVATE: {
                return KiwiReflection2.isPackagePrivate(member);
            }
        }
        throw new IllegalArgumentException("Illegal or unknown JavaAccessModifier: " + modifier);
    }

    public static boolean hasAccessModifier(Class<?> clazz, JavaAccessModifier modifier) {
        switch (modifier) {
            case PUBLIC: {
                return KiwiReflection2.isPublic(clazz);
            }
            case PROTECTED: {
                return KiwiReflection2.isProtected(clazz);
            }
            case PRIVATE: {
                return KiwiReflection2.isPrivate(clazz);
            }
            case PACKAGE_PRIVATE: {
                return KiwiReflection2.isPackagePrivate(clazz);
            }
        }
        throw new IllegalArgumentException("Illegal or unknown JavaAccessModifier: " + modifier);
    }

    public static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isProtected(Member member) {
        return Modifier.isProtected(member.getModifiers());
    }

    public static boolean isProtected(Class<?> clazz) {
        return Modifier.isProtected(clazz.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isPrivate(Class<?> clazz) {
        return Modifier.isPrivate(clazz.getModifiers());
    }

    public static boolean isPackagePrivate(Member member) {
        return !KiwiReflection2.isPublic(member) && !KiwiReflection2.isProtected(member) && !KiwiReflection2.isPrivate(member);
    }

    public static boolean isPackagePrivate(Class<?> clazz) {
        return !KiwiReflection2.isPublic(clazz) && !KiwiReflection2.isProtected(clazz) && !KiwiReflection2.isPrivate(clazz);
    }

    @Generated
    private KiwiReflection2() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum JavaAccessModifier {
        PUBLIC,
        PROTECTED,
        PRIVATE,
        PACKAGE_PRIVATE;

    }
}

