/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.servlet;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.ServletRequest;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.collect.KiwiArrays;

@Beta
public final class KiwiServletRequests {
    public static final String X509_CERTIFICATE_ATTRIBUTE = "javax.servlet.request.X509Certificate";

    public static boolean hasCertificates(ServletRequest request) {
        return Objects.nonNull(request.getAttribute(X509_CERTIFICATE_ATTRIBUTE));
    }

    public static @Nullable X509Certificate[] getCertificates(ServletRequest request) {
        return (X509Certificate[])request.getAttribute(X509_CERTIFICATE_ATTRIBUTE);
    }

    public static Optional<X509Certificate[]> getCertificatesOrEmpty(ServletRequest request) {
        X509Certificate[] certificates = KiwiServletRequests.getCertificates(request);
        return Optional.ofNullable(certificates);
    }

    public static List<X509Certificate> getCertificatesAsList(ServletRequest request) {
        X509Certificate[] certificates = KiwiServletRequests.getCertificates(request);
        return Objects.isNull(certificates) ? List.of() : List.of(certificates);
    }

    public static boolean hasCertificateIn(@Nullable X509Certificate[] certificateChain) {
        return KiwiArrays.isNotNullOrEmpty((Object[])certificateChain) && Objects.nonNull(certificateChain[0]);
    }

    public static boolean doesNotHaveCertificateIn(@Nullable X509Certificate[] certificateChain) {
        return KiwiArrays.isNullOrEmpty((Object[])certificateChain) || Objects.isNull(certificateChain[0]);
    }

    public static X509Certificate firstCertificate(X509Certificate[] certificateChain) {
        Preconditions.checkState((Objects.nonNull(certificateChain) && certificateChain.length > 0 ? 1 : 0) != 0, (Object)"certificateChain must not be null and must have length > 0");
        return certificateChain[0];
    }

    public static Optional<X509Certificate> firstCertificateOrEmpty(@Nullable X509Certificate[] certificateChain) {
        if (KiwiArrays.isNullOrEmpty((Object[])certificateChain)) {
            return Optional.empty();
        }
        return Optional.of(certificateChain[0]);
    }

    @Generated
    private KiwiServletRequests() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

