/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.slf4j;

import com.google.common.annotations.Beta;
import java.time.Duration;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.beta.slf4j.KiwiSlf4j;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@Beta
public class TimestampingLogger {
    private final Logger logger;
    private long previousTimestamp;

    public TimestampingLogger(Logger logger) {
        this.logger = (Logger)KiwiPreconditions.requireNotNull((Object)logger);
    }

    public void traceLogElapsed(String message, Object ... args) {
        this.logElapsed(Level.TRACE, message, args);
    }

    public void debugLogElapsed(String message, Object ... args) {
        this.logElapsed(Level.DEBUG, message, args);
    }

    public void logElapsed(Level level, String message, Object ... args) {
        if (KiwiSlf4j.isEnabled(this.logger, level)) {
            long now = System.nanoTime();
            KiwiSlf4j.log(this.logger, level, message, args);
            TimestampingLogger.logElapsedSincePreviousTimestamp(this.logger, level, now, this.previousTimestamp);
            this.previousTimestamp = now;
        }
    }

    private static void logElapsedSincePreviousTimestamp(Logger logger, Level level, long now, long previousTimestamp) {
        if (previousTimestamp > 0L) {
            long diffInNanos = now - previousTimestamp;
            KiwiSlf4j.log(logger, level, "[elapsed time since previous: {} nanoseconds / {} millis]", (Object)diffInNanos, (Object)Duration.ofNanos(diffInNanos).toMillis());
        } else {
            KiwiSlf4j.log(logger, level, "[elapsed time since previous: N/A (no previous timestamp)]");
        }
    }

    public void traceLogAppendingElapsed(String message, Object ... args) {
        this.logAppendingElapsed(Level.TRACE, message, args);
    }

    public void debugLogAppendingElapsed(String message, Object ... args) {
        this.logAppendingElapsed(Level.DEBUG, message, args);
    }

    public void logAppendingElapsed(Level level, String message, Object ... args) {
        if (KiwiSlf4j.isEnabled(this.logger, level)) {
            long now = System.nanoTime();
            String formattedMessage = KiwiStrings.f((String)message, (Object[])args);
            TimestampingLogger.logAppendingElapsedSincePreviousTimestamp(this.logger, level, formattedMessage, now, this.previousTimestamp);
            this.previousTimestamp = now;
        }
    }

    private static void logAppendingElapsedSincePreviousTimestamp(Logger logger, Level level, String formattedMessage, long now, long previousTimestamp) {
        if (previousTimestamp > 0L) {
            long diffInNanos = now - previousTimestamp;
            KiwiSlf4j.log(logger, level, "{} [elapsed time since previous: {} nanoseconds / {} millis]", formattedMessage, diffInNanos, Duration.ofNanos(diffInNanos).toMillis());
        } else {
            KiwiSlf4j.log(logger, level, "{} [elapsed time since previous: N/A (no previous timestamp)]", (Object)formattedMessage);
        }
    }
}

