/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.test.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.google.common.annotations.Beta;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Beta
public class InMemoryAppender
extends AppenderBase<ILoggingEvent> {
    private final AtomicInteger messageOrder = new AtomicInteger();
    private final ConcurrentMap<Integer, ILoggingEvent> eventMap = new ConcurrentHashMap<Integer, ILoggingEvent>();

    protected synchronized void append(ILoggingEvent eventObject) {
        this.eventMap.put(this.messageOrder.incrementAndGet(), eventObject);
    }

    public synchronized void clearEvents() {
        this.messageOrder.set(0);
        this.eventMap.clear();
    }

    public Map<Integer, ILoggingEvent> getEventMap() {
        return Map.copyOf(this.eventMap);
    }

    public List<ILoggingEvent> getOrderedEvents() {
        return this.getOrderedEventStream().collect(Collectors.toList());
    }

    public List<String> getOrderedEventMessages() {
        return this.getOrderedEventStream().map(ILoggingEvent::getFormattedMessage).collect(Collectors.toList());
    }

    public Stream<ILoggingEvent> getOrderedEventStream() {
        return this.eventMap.values().stream().sorted(Comparator.comparing(ILoggingEvent::getTimeStamp));
    }
}

