/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.net;

import com.google.common.annotations.Beta;
import java.beans.ConstructorProperties;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;

@Beta
public final class KiwiInternetAddresses2 {
    public static SimpleAddressHolder resolveLocalAddressPreferringSupplied(Supplier<String> hostnameSupplier, Supplier<String> ipSupplier) {
        KiwiPreconditions.checkArgumentNotNull(hostnameSupplier);
        KiwiPreconditions.checkArgumentNotNull(ipSupplier);
        String suppliedHostname = hostnameSupplier.get();
        String suppliedIp = ipSupplier.get();
        if (StringUtils.isBlank((CharSequence)suppliedHostname) || StringUtils.isBlank((CharSequence)suppliedIp)) {
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                String hostname = StringUtils.isBlank((CharSequence)suppliedHostname) ? localhost.getHostName() : suppliedHostname;
                String ip = StringUtils.isBlank((CharSequence)suppliedIp) ? localhost.getHostAddress() : suppliedIp;
                return SimpleAddressHolder.of(hostname, ip);
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Received an unexpected unknown host exception trying to get local host", e);
            }
        }
        return SimpleAddressHolder.of(suppliedHostname, suppliedIp);
    }

    @Generated
    private KiwiInternetAddresses2() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class SimpleAddressHolder {
        private final String hostname;
        private final String ip;

        @ConstructorProperties(value={"hostname", "ip"})
        @Generated
        private SimpleAddressHolder(String hostname, String ip) {
            this.hostname = hostname;
            this.ip = ip;
        }

        @Generated
        public static SimpleAddressHolder of(String hostname, String ip) {
            return new SimpleAddressHolder(hostname, ip);
        }

        @Generated
        public String getHostname() {
            return this.hostname;
        }

        @Generated
        public String getIp() {
            return this.ip;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleAddressHolder)) {
                return false;
            }
            SimpleAddressHolder other = (SimpleAddressHolder)o;
            String this$hostname = this.getHostname();
            String other$hostname = other.getHostname();
            if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            return !(this$ip == null ? other$ip != null : !this$ip.equals(other$ip));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hostname = this.getHostname();
            result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "KiwiInternetAddresses2.SimpleAddressHolder(hostname=" + this.getHostname() + ", ip=" + this.getIp() + ")";
        }
    }
}

