/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base.process;

import com.google.common.annotations.Beta;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.kiwiproject.base.process.ProcessHelper;
import org.kiwiproject.beta.base.process.ProcessResult;
import org.kiwiproject.io.KiwiIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class ProcessHelpers {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(ProcessHelpers.class);
    private static final int DEFAULT_TIMEOUT_MILLIS = 5000;

    public static ProcessResult execute(ProcessHelper processHelper, List<String> command) {
        return ProcessHelpers.execute(processHelper, command, 5000, TimeUnit.MILLISECONDS);
    }

    public static ProcessResult execute(ProcessHelper processHelper, List<String> command, int timeout, TimeUnit timeoutUnit) {
        int timeoutMillis = Ints.checkedCast((long)timeoutUnit.toMillis(timeout));
        return ProcessHelpers.tryExecute(processHelper, command, timeoutMillis);
    }

    private static ProcessResult tryExecute(ProcessHelper processHelper, List<String> command, int timeoutMillis) {
        try {
            return CompletableFuture.supplyAsync(() -> ProcessHelpers.executeSync(processHelper, command, timeoutMillis)).get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Interrupted while executing command with timeout {} millis: {}", new Object[]{timeoutMillis, command, e});
            return ProcessHelpers.processResultFromException(e, timeoutMillis);
        }
        catch (Exception e) {
            LOG.error("{} while executing command with timeout {} millis: {}", new Object[]{e.getClass().getSimpleName(), timeoutMillis, command, e});
            return ProcessHelpers.processResultFromException(e, timeoutMillis);
        }
    }

    private static ProcessResult executeSync(ProcessHelper processHelper, List<String> command, int timeoutMillis) {
        Process process = processHelper.launch(command);
        List stdOut = KiwiIO.readLinesFromInputStreamOf((Process)process);
        List stdErr = KiwiIO.readLinesFromErrorStreamOf((Process)process);
        Optional exitCodeOptional = processHelper.waitForExit(process, (long)timeoutMillis, TimeUnit.MILLISECONDS);
        return ProcessResult.builder().exitCode(exitCodeOptional.orElse(null)).timedOut(exitCodeOptional.isEmpty()).timeoutThresholdMillis(timeoutMillis).stdOutLines(stdOut).stdErrLines(stdErr).build();
    }

    private static ProcessResult processResultFromException(Exception ex, int timeoutMillis) {
        boolean timedOut = ex instanceof TimeoutException;
        Throwable error = ex instanceof ExecutionException ? ex.getCause() : ex;
        return ProcessResult.builder().error(error).timedOut(timedOut).timeoutThresholdMillis(timeoutMillis).stdOutLines(List.of()).stdErrLines(List.of()).build();
    }

    @Generated
    private ProcessHelpers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

