/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.dropwizard;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.Beta;
import io.dropwizard.logging.DropwizardLayout;
import io.dropwizard.logging.FileAppenderFactory;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.filter.LevelFilterFactory;
import io.dropwizard.logging.layout.LayoutFactory;
import java.io.File;
import java.util.Optional;
import java.util.TimeZone;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.jar.KiwiJars;

@JsonTypeName(value="rollingWithDefaults")
@Beta
public class DefaultingFileAppenderFactory<E extends DeferredProcessingAware>
extends FileAppenderFactory<E> {
    private static final String DEFAULT_LOG_FORMAT = "%-5level [%date] [%thread] %logger{5}: %message%n";
    private boolean useDefaultDropwizardLogFormat;

    public Appender<E> build(LoggerContext context, String applicationName, LayoutFactory<E> layoutFactory, LevelFilterFactory<E> levelFilterFactory, AsyncAppenderFactory<E> asyncAppenderFactory) {
        String nonNullApplicationName = Optional.ofNullable(applicationName).orElse("service");
        if (StringUtils.isBlank((CharSequence)this.getCurrentLogFilename())) {
            this.setCurrentLogFilename(DefaultingFileAppenderFactory.filePathFor(nonNullApplicationName));
        }
        if (StringUtils.isBlank((CharSequence)this.getArchivedLogFilenamePattern())) {
            this.setArchivedLogFilenamePattern(DefaultingFileAppenderFactory.archiveFileNamePatternFor(nonNullApplicationName));
        }
        if (StringUtils.isBlank((CharSequence)this.getLogFormat())) {
            String logFormat = DefaultingFileAppenderFactory.newLogFormat(this.isUseDefaultDropwizardLogFormat(), this.getTimeZone());
            this.setLogFormat(logFormat);
        }
        return super.build(context, applicationName, layoutFactory, levelFilterFactory, asyncAppenderFactory);
    }

    private static String filePathFor(String applicationName) {
        return DefaultingFileAppenderFactory.logPathFor(applicationName, ".log");
    }

    private static String archiveFileNamePatternFor(String applicationName) {
        return DefaultingFileAppenderFactory.logPathFor(applicationName, "-%d.log.gz");
    }

    private static String logPathFor(String applicationName, String suffix) {
        String path = KiwiJars.getDirectoryPath(DefaultingFileAppenderFactory.class).orElse("./");
        return String.join((CharSequence)File.separator, path, applicationName) + suffix;
    }

    private static String newLogFormat(boolean useDefaultDropwizardLogFormat, TimeZone timeZone) {
        if (useDefaultDropwizardLogFormat) {
            DropwizardLayout dropwizardLayout = new DropwizardLayout(new LoggerContext(), timeZone);
            return dropwizardLayout.getPattern();
        }
        return DEFAULT_LOG_FORMAT;
    }

    @Generated
    public boolean isUseDefaultDropwizardLogFormat() {
        return this.useDefaultDropwizardLogFormat;
    }

    @Generated
    public void setUseDefaultDropwizardLogFormat(boolean useDefaultDropwizardLogFormat) {
        this.useDefaultDropwizardLogFormat = useDefaultDropwizardLogFormat;
    }
}

