/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base.jar;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import lombok.Generated;
import org.kiwiproject.base.KiwiStrings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class JarManifests {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(JarManifests.class);

    public static String getMainAttributeValueOrThrow(Class<?> theClass, String name) {
        return JarManifests.getMainAttributeValue(theClass, name).orElseThrow(() -> new IllegalStateException(KiwiStrings.f((String)"Unable to get value for main attribute {} for {}", (Object[])new Object[]{name, theClass})));
    }

    public static Optional<String> getMainAttributeValue(Class<?> theClass, String name) {
        return JarManifests.getManifest(theClass).map(manifest -> JarManifests.getMainAttributeValue(manifest, name)).flatMap(Function.identity());
    }

    public static Optional<String> getMainAttributeValue(Manifest manifest, String name) {
        String value = manifest.getMainAttributes().getValue(name);
        return Optional.ofNullable(value);
    }

    public static Map<String, String> getMainAttributesAsMapOrThrow(Class<?> theClass) {
        Manifest manifest = JarManifests.getManifestOrThrow(theClass);
        return JarManifests.getMainAttributesAsMap(manifest);
    }

    public static Map<String, String> getMainAttributesAsMap(Manifest manifest) {
        return manifest.getMainAttributes().entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
    }

    public static Manifest getManifestOrThrow(Class<?> theClass) {
        return JarManifests.getManifest(theClass).orElseThrow(() -> new IllegalStateException("Unable to get manifest for " + theClass));
    }

    public static Optional<Manifest> getManifest(Class<?> theClass) {
        ClassHolder classHolder = new ClassHolder(theClass);
        return JarManifests.getManifest(classHolder);
    }

    @VisibleForTesting
    static Optional<Manifest> getManifest(ClassHolder holder) {
        Class<?> theClass = holder.getContainedClass();
        try {
            CodeSource codeSource = holder.getProtectionDomain().getCodeSource();
            if (Objects.nonNull(codeSource)) {
                URL location = codeSource.getLocation();
                LOG.trace("CodeSource location of {}: {}", theClass, (Object)location);
                if (Objects.nonNull(location)) {
                    return JarManifests.getManifest(location.toURI());
                }
            }
            LOG.warn("Unable to get manifest of JAR file for {}", theClass);
            return Optional.empty();
        }
        catch (Exception e) {
            LOG.error("Error getting manifest of JAR for {}", theClass, (Object)e);
            return Optional.empty();
        }
    }

    public static Optional<Manifest> getManifest(URI jarFileURI) {
        Optional<Manifest> optional;
        JarFile jarFile = new JarFile(new File(jarFileURI));
        try {
            optional = Optional.of(jarFile.getManifest());
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Error getting manifest of JAR for URI {}", (Object)jarFileURI, (Object)e);
                return Optional.empty();
            }
        }
        jarFile.close();
        return optional;
    }

    @Generated
    private JarManifests() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @VisibleForTesting
    static class ClassHolder {
        private final Class<?> theClass;

        Class<?> getContainedClass() {
            return this.theClass;
        }

        ProtectionDomain getProtectionDomain() {
            return this.theClass.getProtectionDomain();
        }

        @ConstructorProperties(value={"theClass"})
        @Generated
        public ClassHolder(Class<?> theClass) {
            this.theClass = theClass;
        }
    }
}

