/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.time;

import com.google.common.annotations.Beta;
import java.beans.ConstructorProperties;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.time.StopWatch;

@Beta
public final class Timing {
    public static <R> TimedWithResult<R> timeWithResult(StopWatch stopWatch, Supplier<R> operation) {
        R result;
        stopWatch.reset();
        stopWatch.start();
        try {
            result = operation.get();
        }
        finally {
            stopWatch.stop();
        }
        return new TimedWithResult<R>(stopWatch.getTime(), result);
    }

    public static TimedNoResult timeNoResult(StopWatch stopWatch, Runnable operation) {
        stopWatch.reset();
        stopWatch.start();
        try {
            operation.run();
        }
        finally {
            stopWatch.stop();
        }
        return new TimedNoResult(stopWatch.getTime());
    }

    @Generated
    private Timing() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class TimedNoResult
    implements Timed {
        private final long elapsedMillis;

        @ConstructorProperties(value={"elapsedMillis"})
        @Generated
        public TimedNoResult(long elapsedMillis) {
            this.elapsedMillis = elapsedMillis;
        }

        @Override
        @Generated
        public long getElapsedMillis() {
            return this.elapsedMillis;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimedNoResult)) {
                return false;
            }
            TimedNoResult other = (TimedNoResult)o;
            return this.getElapsedMillis() == other.getElapsedMillis();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $elapsedMillis = this.getElapsedMillis();
            result = result * 59 + (int)($elapsedMillis >>> 32 ^ $elapsedMillis);
            return result;
        }

        @Generated
        public String toString() {
            return "Timing.TimedNoResult(elapsedMillis=" + this.getElapsedMillis() + ")";
        }
    }

    public static final class TimedWithResult<R>
    implements Timed {
        private final long elapsedMillis;
        private final R result;

        @ConstructorProperties(value={"elapsedMillis", "result"})
        @Generated
        public TimedWithResult(long elapsedMillis, R result) {
            this.elapsedMillis = elapsedMillis;
            this.result = result;
        }

        @Override
        @Generated
        public long getElapsedMillis() {
            return this.elapsedMillis;
        }

        @Generated
        public R getResult() {
            return this.result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimedWithResult)) {
                return false;
            }
            TimedWithResult other = (TimedWithResult)o;
            if (this.getElapsedMillis() != other.getElapsedMillis()) {
                return false;
            }
            R this$result = this.getResult();
            R other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $elapsedMillis = this.getElapsedMillis();
            result = result * 59 + (int)($elapsedMillis >>> 32 ^ $elapsedMillis);
            R $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Timing.TimedWithResult(elapsedMillis=" + this.getElapsedMillis() + ", result=" + this.getResult() + ")";
        }
    }

    public static interface Timed {
        public long getElapsedMillis();
    }
}

