/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.reflect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiLists;

@Beta
public final class TypeInfo {
    private final Type rawType;
    private final List<Type> genericTypes;

    @VisibleForTesting
    TypeInfo(Type rawType, List<Type> genericTypes) {
        this.rawType = (Type)KiwiPreconditions.requireNotNull((Object)rawType);
        this.genericTypes = (List)KiwiPreconditions.requireNotNull(genericTypes);
    }

    public static TypeInfo ofType(@NonNull Type type) {
        TypeInfo.checkTypeArgument(type);
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return TypeInfo.ofParameterizedType(parameterizedType);
        }
        return TypeInfo.ofSimpleType(type);
    }

    public static TypeInfo ofSimpleType(@NonNull Type simpleType) {
        TypeInfo.checkTypeArgument(simpleType);
        Preconditions.checkArgument((!(simpleType instanceof ParameterizedType) ? 1 : 0) != 0, (Object)"Do not call this method with a ParameterizedType. Use TypeInfo#ofType or TypeInfo#ofParameterizedType.");
        return new TypeInfo(simpleType, List.of());
    }

    public static TypeInfo ofParameterizedType(@NonNull ParameterizedType parameterizedType) {
        TypeInfo.checkTypeArgument(parameterizedType);
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        List<Type> genericTypes = Objects.isNull(typeArgs) ? List.of() : List.of(typeArgs);
        return new TypeInfo(parameterizedType.getRawType(), genericTypes);
    }

    private static void checkTypeArgument(Type type) {
        KiwiPreconditions.checkArgumentNotNull((Object)type, (String)"type to inspect must not be null");
    }

    public boolean isCollection() {
        return this.isRawTypeAssignableTo(Collection.class);
    }

    public boolean isCollectionOf(@NonNull Class<?> genericType) {
        TypeInfo.checkGenericTypeArgument(genericType);
        return this.isCollection() && this.hasOnlyGenericType(genericType);
    }

    public boolean isListOf(@NonNull Class<?> genericType) {
        TypeInfo.checkGenericTypeArgument(genericType);
        return this.isRawTypeAssignableTo(List.class) && this.hasOnlyGenericType(genericType);
    }

    public boolean isSetOf(@NonNull Class<?> genericType) {
        TypeInfo.checkGenericTypeArgument(genericType);
        return this.isRawTypeAssignableTo(Set.class) && this.hasOnlyGenericType(genericType);
    }

    private boolean hasOnlyGenericType(Class<?> genericType) {
        return this.getOnlyGenericType().equals(genericType);
    }

    public boolean isMap() {
        return this.isRawTypeAssignableTo(Map.class);
    }

    public boolean isMapOf(@NonNull Class<?> keyGenericType, @NonNull Class<?> valueGenericType) {
        TypeInfo.checkGenericTypeArgument(keyGenericType);
        TypeInfo.checkGenericTypeArgument(valueGenericType);
        return this.isMap() && ((Type)KiwiLists.first(this.genericTypes)).equals(keyGenericType) && ((Type)KiwiLists.second(this.genericTypes)).equals(valueGenericType);
    }

    private static void checkGenericTypeArgument(Class<?> genericType) {
        KiwiPreconditions.checkArgumentNotNull(genericType, (String)"genericType to check must not be null");
    }

    public boolean hasExactRawType(@NonNull Class<?> testType) {
        KiwiPreconditions.checkArgumentNotNull(testType);
        return this.rawType.equals(testType);
    }

    public boolean hasRawTypeAssignableTo(@NonNull Class<?> testType) {
        KiwiPreconditions.checkArgumentNotNull(testType);
        return this.isRawTypeAssignableTo(testType);
    }

    private boolean isRawTypeAssignableTo(Class<?> testType) {
        Class<?> clazz = TypeInfo.getClassForName(this.rawType.getTypeName());
        return testType.isAssignableFrom(clazz);
    }

    @VisibleForTesting
    static Class<?> getClassForName(String typeName) {
        try {
            return Class.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public Type getOnlyGenericType() {
        int genericTypeCount = this.genericTypes.size();
        Preconditions.checkState((genericTypeCount == 1 ? 1 : 0) != 0, (String)"expected exactly one generic type but found %s", (int)genericTypeCount);
        return (Type)KiwiLists.first(this.genericTypes);
    }

    @Generated
    public Type getRawType() {
        return this.rawType;
    }

    @Generated
    public List<Type> getGenericTypes() {
        return this.genericTypes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeInfo)) {
            return false;
        }
        TypeInfo other = (TypeInfo)o;
        Type this$rawType = this.getRawType();
        Type other$rawType = other.getRawType();
        if (this$rawType == null ? other$rawType != null : !this$rawType.equals(other$rawType)) {
            return false;
        }
        List<Type> this$genericTypes = this.getGenericTypes();
        List<Type> other$genericTypes = other.getGenericTypes();
        return !(this$genericTypes == null ? other$genericTypes != null : !((Object)this$genericTypes).equals(other$genericTypes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $rawType = this.getRawType();
        result = result * 59 + ($rawType == null ? 43 : $rawType.hashCode());
        List<Type> $genericTypes = this.getGenericTypes();
        result = result * 59 + ($genericTypes == null ? 43 : ((Object)$genericTypes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TypeInfo(rawType=" + this.getRawType() + ", genericTypes=" + this.getGenericTypes() + ")";
    }
}

