/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.test.servlet;

import com.google.common.annotations.Beta;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;

@Beta
public final class KiwiServletMocks {
    public static HttpServletRequest mockHttpServletRequestWithCertificate(String dn) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        X509Certificate certificate = KiwiServletMocks.mockX509Certificate(dn);
        Mockito.when((Object)request.getAttribute("javax.servlet.request.X509Certificate")).thenReturn((Object)new X509Certificate[]{certificate});
        return request;
    }

    public static HttpServletRequest mockHttpServletRequestWithNoCertificate() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getAttribute("javax.servlet.request.X509Certificate")).thenReturn(null);
        return request;
    }

    public static X509Certificate mockX509Certificate(String dn) {
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        Principal principal = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)cert.getSubjectDN()).thenReturn((Object)principal);
        Mockito.when((Object)principal.getName()).thenReturn((Object)dn);
        X500Principal x500Principal = new X500Principal(dn);
        Mockito.when((Object)cert.getSubjectX500Principal()).thenReturn((Object)x500Principal);
        return cert;
    }

    public static ArgumentMatcher<X509Certificate[]> matchesExpectedCertArrayBySubjectDN(String subjectDn) {
        return certs -> {
            Assertions.assertThat((Object[])certs).extracting(cert -> cert.getSubjectDN().getName()).containsExactly((Object[])new String[]{subjectDn});
            return true;
        };
    }

    public static ArgumentMatcher<X509Certificate> matchesExpectedCertBySubjectDN(String subjectDn) {
        return cert -> {
            Assertions.assertThat((String)cert.getSubjectDN().getName()).isEqualTo(subjectDn);
            return true;
        };
    }

    public static ArgumentMatcher<X509Certificate[]> matchesCertArrayByX500PrincipalName(String name) {
        return object -> {
            Assertions.assertThat((Object[])object).isInstanceOf(X509Certificate[].class);
            X500Principal x500Principal = new X500Principal(name);
            Assertions.assertThat((Object[])object).extracting(cert -> cert.getSubjectX500Principal().getName()).containsExactly((Object[])new String[]{x500Principal.getName()});
            return true;
        };
    }

    public static ArgumentMatcher<X509Certificate> matchesExpectedCertByX500PrincipalName(String name) {
        return cert -> {
            X500Principal x500Principal = new X500Principal(name);
            Assertions.assertThat((String)cert.getSubjectX500Principal().getName()).isEqualTo(x500Principal.getName());
            return true;
        };
    }

    @Generated
    private KiwiServletMocks() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

