/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.base.KiwiPreconditions;

@Beta
public final class KiwiStrings2 {
    @Generated
    private static final Object $LOCK = new Object[0];
    private static final Pattern NULL_CHAR_PATTERN = Pattern.compile("\u0000");
    public static final int DEFAULT_RANDOM_CASE_GENERATION_LIMIT = 10000;
    @VisibleForTesting
    static int randomCaseGenerationLimit = 10000;

    public static String camelToSnakeCase(String value) {
        return KiwiStrings2.camelToSnakeCaseOrEmpty(value).orElseThrow(() -> new IllegalArgumentException("value must not be blank"));
    }

    public static Optional<String> camelToSnakeCaseOrEmpty(@Nullable String value) {
        return Optional.ofNullable(KiwiStrings2.camelToSnakeCaseOrNull(value));
    }

    public static String camelToSnakeCaseOrNull(@Nullable String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return (String)CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE).convert((Object)value);
    }

    public static String replaceNullCharactersWithEmpty(@Nullable String str) {
        return KiwiStrings2.replaceNullCharacters(str, "", null);
    }

    public static String replaceNullCharacters(@Nullable String str, String replacement, @Nullable String defaultValue) {
        return Optional.ofNullable(str).map(s -> NULL_CHAR_PATTERN.matcher((CharSequence)s).replaceAll(replacement)).orElse(defaultValue);
    }

    public static Set<String> randomCaseVariants(@NonNull String input) {
        return KiwiStrings2.randomCaseVariants(input, Locale.getDefault());
    }

    public static Set<String> randomCaseVariants(@NonNull String input, @NonNull Locale locale) {
        return KiwiStrings2.randomCaseVariants(input, 3, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int randomCaseGenerationLimit() {
        Object object = $LOCK;
        synchronized (object) {
            return randomCaseGenerationLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRandomCaseGenerationLimit(int limit) {
        Object object = $LOCK;
        synchronized (object) {
            randomCaseGenerationLimit = limit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetRandomCaseGenerationLimit() {
        Object object = $LOCK;
        synchronized (object) {
            randomCaseGenerationLimit = 10000;
        }
    }

    public static Set<String> randomCaseVariants(@NonNull String input, int desiredSize) {
        return KiwiStrings2.randomCaseVariants(input, desiredSize, Locale.getDefault());
    }

    public static Set<String> randomCaseVariants(@NonNull String input, int desiredSize, @NonNull Locale locale) {
        KiwiPreconditions.checkArgumentNotBlank((String)input);
        KiwiPreconditions.checkPositive((int)desiredSize);
        KiwiPreconditions.checkArgumentNotNull((Object)locale);
        int maxNumberOfVariants = KiwiStrings2.maxVariantsOf(input);
        int mathematicalLimit = Math.min(desiredSize, maxNumberOfVariants);
        int hardLimit = Math.min(mathematicalLimit, KiwiStrings2.randomCaseGenerationLimit());
        return Stream.generate(() -> KiwiStrings2.randomlyCapitalize(input, locale)).distinct().limit(hardLimit).collect(Collectors.toUnmodifiableSet());
    }

    private static int maxVariantsOf(@NonNull String input) {
        int length = input.length();
        return length > 32 ? Integer.MAX_VALUE : (int)Math.pow(2.0, length);
    }

    public static String randomlyCapitalize(@NonNull String input, @NonNull Locale locale) {
        KiwiPreconditions.checkArgumentNotBlank((String)input);
        KiwiPreconditions.checkArgumentNotNull((Object)locale);
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        return IntStream.range(0, input.length()).mapToObj(idx -> {
            String chStr = String.valueOf(input.charAt(idx));
            return rand.nextBoolean() ? chStr.toUpperCase(locale) : chStr.toLowerCase(locale);
        }).collect(Collectors.joining());
    }

    public static Set<String> standardCaseVariants(@NonNull String input) {
        return KiwiStrings2.standardCaseVariants(input, Locale.getDefault());
    }

    public static Set<String> standardCaseVariants(@NonNull String input, @NonNull Locale locale) {
        KiwiPreconditions.checkArgumentNotBlank((String)input);
        KiwiPreconditions.checkArgumentNotNull((Object)locale);
        String upperCase = input.toUpperCase(locale);
        String lowerCase = input.toLowerCase(locale);
        String sentenceCase = KiwiStrings2.sentenceCase(input, locale);
        HashSet variants = Sets.newHashSet((Object[])new String[]{upperCase, lowerCase, sentenceCase});
        return Set.copyOf(variants);
    }

    private static String sentenceCase(@NonNull String input, @NonNull Locale locale) {
        String upperCaseFirstChar = input.substring(0, 1).toUpperCase(locale);
        String lowerCaseRemainingChars = input.substring(1).toLowerCase(locale);
        return upperCaseFirstChar + lowerCaseRemainingChars;
    }

    @Generated
    private KiwiStrings2() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

