/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;

@Beta
public final class KiwiFutures {
    private static final Function<InterruptedException, IllegalStateException> DEFAULT_INTERRUPTED_EXCEPTION_HANDLER = e -> {
        Thread.currentThread().interrupt();
        return new IllegalStateException("Task was interrupted", (Throwable)e);
    };
    @VisibleForTesting
    static Function<InterruptedException, IllegalStateException> interruptedExceptionHandler = DEFAULT_INTERRUPTED_EXCEPTION_HANDLER;

    @VisibleForTesting
    static void resetInterruptedExceptionHandler() {
        interruptedExceptionHandler = DEFAULT_INTERRUPTED_EXCEPTION_HANDLER;
    }

    public static <V> V resultNow(Future<V> future) {
        KiwiPreconditions.checkArgumentNotNull(future);
        if (KiwiFutures.isNotDone(future)) {
            throw new IllegalStateException("Task has not completed");
        }
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw interruptedExceptionHandler.apply(e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Task completed with exception", e.getCause());
        }
        catch (CancellationException e) {
            throw new IllegalStateException("Task was cancelled", e);
        }
    }

    public static <V> Throwable exceptionNow(Future<V> future) {
        KiwiPreconditions.checkArgumentNotNull(future);
        if (KiwiFutures.isNotDone(future)) {
            throw new IllegalStateException("Task has not completed");
        }
        if (future.isCancelled()) {
            throw new IllegalStateException("Task was cancelled");
        }
        try {
            future.get();
            throw new IllegalStateException("Task completed with a result");
        }
        catch (InterruptedException e) {
            throw interruptedExceptionHandler.apply(e);
        }
        catch (ExecutionException e) {
            return e.getCause();
        }
    }

    public static <V> FutureState state(Future<V> future) {
        KiwiPreconditions.checkArgumentNotNull(future);
        if (KiwiFutures.isNotDone(future)) {
            return FutureState.RUNNING;
        }
        if (future.isCancelled()) {
            return FutureState.CANCELLED;
        }
        try {
            future.get();
            return FutureState.SUCCESS;
        }
        catch (InterruptedException e) {
            throw interruptedExceptionHandler.apply(e);
        }
        catch (ExecutionException e) {
            return FutureState.FAILED;
        }
    }

    public static <V> boolean isNotDone(Future<V> future) {
        return !future.isDone();
    }

    @Generated
    private KiwiFutures() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum FutureState {
        RUNNING,
        SUCCESS,
        FAILED,
        CANCELLED;

    }
}

