/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.net;

import com.google.common.annotations.Beta;
import com.google.common.net.MediaType;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;

@Beta
public final class KiwiMediaTypes {
    private static final String APPLICATION_TYPE = "application";
    private static final String TEXT_TYPE = "text";
    private static final String JSON_SUBTYPE = "json";
    private static final String XML_SUBTYPE = "xml";

    public static boolean isXml(jakarta.ws.rs.core.MediaType mediaType) {
        KiwiPreconditions.checkArgumentNotNull((Object)mediaType, (String)"mediaType must not be null");
        return KiwiMediaTypes.isXml(KiwiMediaTypes.toStringWithoutParameters(mediaType));
    }

    public static boolean isXml(String mediaType) {
        KiwiMediaTypes.checkMediaTypeNotBlank(mediaType);
        MediaType parsedType = MediaType.parse((String)mediaType);
        String type = parsedType.type();
        String subtype = parsedType.subtype();
        return (TEXT_TYPE.equals(type) || APPLICATION_TYPE.equals(type)) && XML_SUBTYPE.equals(subtype);
    }

    public static boolean isJson(jakarta.ws.rs.core.MediaType mediaType) {
        KiwiPreconditions.checkArgumentNotNull((Object)mediaType, (String)"mediaType must not be null");
        return KiwiMediaTypes.isJson(KiwiMediaTypes.toStringWithoutParameters(mediaType));
    }

    public static String toStringWithoutParameters(jakarta.ws.rs.core.MediaType mediaType) {
        return KiwiStrings.f((String)"{}/{}", (Object[])new Object[]{mediaType.getType(), mediaType.getSubtype()});
    }

    public static boolean isJson(String mediaType) {
        KiwiMediaTypes.checkMediaTypeNotBlank(mediaType);
        MediaType parsedType = MediaType.parse((String)mediaType);
        String type = parsedType.type();
        String subtype = parsedType.subtype();
        return APPLICATION_TYPE.equals(type) && JSON_SUBTYPE.equals(subtype);
    }

    public static boolean matchesType(String mediaType, String typeToMatch) {
        KiwiMediaTypes.checkMediaTypeNotBlank(mediaType);
        KiwiPreconditions.checkArgumentNotBlank((String)typeToMatch, (String)"typeToMatch must not be blank");
        MediaType parsedType = MediaType.parse((String)mediaType);
        String type = parsedType.type();
        return typeToMatch.equals(type);
    }

    public static boolean matchesSubtype(String mediaType, String subtypeToMatch) {
        KiwiMediaTypes.checkMediaTypeNotBlank(mediaType);
        KiwiPreconditions.checkArgumentNotBlank((String)subtypeToMatch, (String)"subtypeToMatch must not be blank");
        MediaType parsedType = MediaType.parse((String)mediaType);
        String subtype = parsedType.subtype();
        return subtypeToMatch.equals(subtype);
    }

    private static void checkMediaTypeNotBlank(String mediaType) {
        KiwiPreconditions.checkArgumentNotBlank((String)mediaType, (String)"mediaType must not be blank");
    }

    @Generated
    private KiwiMediaTypes() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

