/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.beta.reflect.KiwiReflection2;
import org.kiwiproject.beta.slf4j.KiwiSlf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Beta
public final class KiwiCloseables {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(KiwiCloseables.class);

    public static void closeAllQuietly(Object ... objects) {
        KiwiCloseables.validateNonNullVarargs(objects);
        Arrays.stream(objects).filter(Objects::nonNull).map(CloseDescriptor::of).forEach(KiwiCloseables::closeQuietly);
    }

    public static void closeQuietly(CloseDescriptor descriptor) {
        KiwiCloseables.validateCloseDescriptor(descriptor);
        Object object = descriptor.object();
        if (Objects.isNull(object)) {
            return;
        }
        if (object instanceof Closeable) {
            Closeable closeable = (Closeable)object;
            KiwiCloseables.closeQuietly(closeable);
            return;
        }
        String methodName = descriptor.closeMethodName();
        Exception exception = KiwiCloseables.tryCloseObject(object, methodName);
        if (Objects.nonNull(exception)) {
            KiwiCloseables.logExceptionClosingObject(Level.WARN, object, methodName, exception);
        }
    }

    public static void closeQuietly(@Nullable Closeable closeable) {
        if (Objects.isNull(closeable)) {
            return;
        }
        Exception exception = KiwiCloseables.tryCloseCloseable(closeable);
        if (Objects.nonNull(exception)) {
            KiwiCloseables.logExceptionClosingClosable(Level.WARN, closeable, exception);
        }
    }

    public static List<CloseResult> closeAll(Object ... objects) {
        KiwiCloseables.validateNonNullVarargs(objects);
        return Arrays.stream(objects).map(CloseDescriptor::of).map(KiwiCloseables::close).toList();
    }

    private static void validateNonNullVarargs(Object ... objects) {
        KiwiPreconditions.checkArgumentNotNull((Object)objects, (String)"don't cast varargs to null!");
    }

    public static CloseResult close(CloseDescriptor descriptor) {
        KiwiCloseables.validateCloseDescriptor(descriptor);
        Object object = descriptor.object();
        if (Objects.isNull(object)) {
            return CloseResult.ofNull();
        }
        if (object instanceof Closeable) {
            Closeable closeable = (Closeable)object;
            return KiwiCloseables.close(closeable);
        }
        String methodName = descriptor.closeMethodName();
        Exception exception = KiwiCloseables.tryCloseObject(object, methodName);
        if (Objects.isNull(exception)) {
            return CloseResult.ofClosed();
        }
        KiwiCloseables.logExceptionClosingObject(Level.TRACE, object, methodName, exception);
        return CloseResult.ofError(exception);
    }

    private static void validateCloseDescriptor(CloseDescriptor descriptor) {
        KiwiPreconditions.checkArgumentNotNull((Object)descriptor);
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)descriptor.closeMethodName()), (Object)"invalid CloseDescriptor! closeMethodName is blank!");
    }

    private static Exception tryCloseObject(Object object, String methodName) {
        try {
            Method method = object.getClass().getDeclaredMethod(methodName, new Class[0]);
            KiwiCloseables.setAccessibleIfNotPublic(method);
            method.invoke(object, new Object[0]);
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    private static void setAccessibleIfNotPublic(Method method) {
        if (!KiwiReflection2.isPublic(method)) {
            method.setAccessible(true);
        }
    }

    private static void logExceptionClosingObject(Level level, Object object, String methodName, Exception exception) {
        KiwiSlf4j.log(LOG, level, "Suppressed exception thrown while closing {} from method {}", object.getClass().getName(), methodName, exception);
    }

    public static CloseResult close(Closeable closeable) {
        if (Objects.isNull(closeable)) {
            return CloseResult.ofNull();
        }
        Exception exception = KiwiCloseables.tryCloseCloseable(closeable);
        if (Objects.isNull(exception)) {
            return CloseResult.ofClosed();
        }
        KiwiCloseables.logExceptionClosingClosable(Level.TRACE, closeable, exception);
        return CloseResult.ofError(exception);
    }

    private static void logExceptionClosingClosable(Level level, Closeable closeable, Exception exception) {
        KiwiSlf4j.log(LOG, level, "Suppressed exception thrown while closing Closeable ({})", (Object)closeable.getClass().getName(), (Object)exception);
    }

    private static Exception tryCloseCloseable(Closeable closeable) {
        try {
            closeable.close();
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    @Generated
    private KiwiCloseables() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class CloseDescriptor {
        private static final String DEFAULT_CLOSE_METHOD_NAME = "close";
        private @Nullable Object object;
        private String closeMethodName;

        public static CloseDescriptor of(@Nullable Object object) {
            return CloseDescriptor.of(object, DEFAULT_CLOSE_METHOD_NAME);
        }

        public static CloseDescriptor of(@Nullable Object object, String closeMethodName) {
            CloseDescriptor closeDescriptor;
            KiwiPreconditions.checkArgumentNotBlank((String)closeMethodName, (String)"closeMethodName must not be blank");
            return object instanceof CloseDescriptor ? (closeDescriptor = (CloseDescriptor)object) : new CloseDescriptor(object, closeMethodName);
        }

        @Generated
        public @Nullable Object object() {
            return this.object;
        }

        @Generated
        public String closeMethodName() {
            return this.closeMethodName;
        }

        @ConstructorProperties(value={"object", "closeMethodName"})
        @Generated
        private CloseDescriptor(@Nullable Object object, String closeMethodName) {
            this.object = object;
            this.closeMethodName = closeMethodName;
        }
    }

    public static class CloseResult {
        private boolean closed;
        private boolean wasNull;
        private @Nullable Exception error;

        public static CloseResult ofClosed() {
            return new CloseResult(true, false, null);
        }

        public static CloseResult ofNull() {
            return new CloseResult(false, true, null);
        }

        public static CloseResult ofError(Exception exception) {
            KiwiPreconditions.checkArgumentNotNull((Object)exception);
            return new CloseResult(false, false, exception);
        }

        public boolean closedOrWasNull() {
            return this.closed || this.wasNull;
        }

        public boolean hasError() {
            return Objects.nonNull(this.error);
        }

        @Generated
        public boolean closed() {
            return this.closed;
        }

        @Generated
        public boolean wasNull() {
            return this.wasNull;
        }

        @Generated
        public @Nullable Exception error() {
            return this.error;
        }

        @ConstructorProperties(value={"closed", "wasNull", "error"})
        @Generated
        private CloseResult(boolean closed, boolean wasNull, @Nullable Exception error) {
            this.closed = closed;
            this.wasNull = wasNull;
            this.error = error;
        }
    }
}

