/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base;

import com.google.common.annotations.Beta;
import java.util.Optional;
import java.util.function.Consumer;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.util.function.KiwiConsumers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
@Beta
public interface CatchingRunnable2
extends Runnable {
    public static CatchingRunnable2 of(Runnable runnable) {
        return CatchingRunnable2.of(null, runnable);
    }

    public static CatchingRunnable2 of(Runnable runnable, Consumer<Exception> exceptionHandler) {
        return CatchingRunnable2.of(null, runnable, exceptionHandler);
    }

    public static CatchingRunnable2 of(String name, Runnable runnable) {
        return CatchingRunnable2.of(name, runnable, KiwiConsumers.noOp());
    }

    public static CatchingRunnable2 of(final String name, final Runnable runnable, final Consumer<Exception> exceptionHandler) {
        KiwiPreconditions.checkArgumentNotNull((Object)runnable, (String)"runnable must not be null");
        KiwiPreconditions.checkArgumentNotNull(exceptionHandler, (String)"handler must not be null");
        return new CatchingRunnable2(){

            @Override
            public Optional<String> name() {
                return Optional.ofNullable(name);
            }

            @Override
            public void runSafely() {
                runnable.run();
            }

            @Override
            public void handleExceptionSafely(Exception exception) {
                exceptionHandler.accept(exception);
            }
        };
    }

    default public Optional<String> name() {
        return Optional.empty();
    }

    @Override
    default public void run() {
        try {
            this.runSafely();
        }
        catch (Exception e) {
            CatchingRunnable2.getLogger().error("Error occurred calling runSafely{}", (Object)this.description(), (Object)e);
            try {
                this.handleExceptionSafely(e);
            }
            catch (Exception ex) {
                CatchingRunnable2.getLogger().error("Error occurred calling handleExceptionSafely{}", (Object)this.description(), (Object)ex);
            }
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(CatchingRunnable2.class);
    }

    private String description() {
        return this.name().map(name -> " [" + name + "]").orElse("");
    }

    default public void handleExceptionSafely(Exception exception) {
    }

    public void runSafely();
}

