/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.dao;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;

@Beta
public class AllowedFields {
    private final Set<String> fieldNames;
    private final Map<String, String> fieldNamesToPrefixedNames;

    public static AllowedFields of(String ... fieldNames) {
        KiwiPreconditions.checkArgumentNotNull((Object)fieldNames, (String)"fieldNames must not be null");
        return AllowedFields.of(Arrays.asList(fieldNames));
    }

    public static AllowedFields of(Collection<String> fieldNames) {
        KiwiPreconditions.checkArgumentNotNull(fieldNames, (String)"fieldNames must not be null");
        Preconditions.checkArgument((!fieldNames.isEmpty() ? 1 : 0) != 0, (Object)"at least one field name must be specified");
        Map<String, String> fieldNameToPrefixedNameMap = fieldNames.stream().map(PrefixAndFieldName::new).collect(Collectors.toUnmodifiableMap(prefixAndName -> prefixAndName.fieldName, prefixAndName -> prefixAndName.prefixedFieldName));
        return new AllowedFields(Set.copyOf(fieldNameToPrefixedNameMap.keySet()), fieldNameToPrefixedNameMap);
    }

    public boolean isAllowed(String fieldName) {
        KiwiPreconditions.checkArgumentNotBlank((String)fieldName);
        return this.fieldNames.contains(fieldName);
    }

    public boolean isPrefixedAllowed(String prefixedFieldName) {
        KiwiPreconditions.checkArgumentNotBlank((String)prefixedFieldName);
        return this.fieldNamesToPrefixedNames.containsValue(prefixedFieldName);
    }

    public void assertAllowed(String fieldName) {
        KiwiPreconditions.checkArgumentNotBlank((String)fieldName);
        if (!this.isAllowed(fieldName)) {
            throw new IllegalArgumentException(fieldName + " is not allowed");
        }
    }

    public void assertPrefixedAllowed(String prefixedFieldName) {
        KiwiPreconditions.checkArgumentNotBlank((String)prefixedFieldName);
        if (!this.isPrefixedAllowed(prefixedFieldName)) {
            throw new IllegalArgumentException(prefixedFieldName + " is not allowed");
        }
    }

    public String getPrefixedFieldName(String fieldName) {
        KiwiPreconditions.checkArgumentNotBlank((String)fieldName);
        return this.fieldNamesToPrefixedNames.get(fieldName);
    }

    @ConstructorProperties(value={"fieldNames", "fieldNamesToPrefixedNames"})
    @Generated
    private AllowedFields(Set<String> fieldNames, Map<String, String> fieldNamesToPrefixedNames) {
        this.fieldNames = fieldNames;
        this.fieldNamesToPrefixedNames = fieldNamesToPrefixedNames;
    }

    private static class PrefixAndFieldName {
        final String fieldName;
        final String prefixedFieldName;

        PrefixAndFieldName(String name) {
            KiwiPreconditions.checkArgumentNotBlank((String)name, (String)"field name must not be blank");
            int lastDot = name.lastIndexOf(46);
            if (lastDot == -1) {
                this.fieldName = name;
                this.prefixedFieldName = name;
            } else {
                if (lastDot == 0 || lastDot == name.length() - 1) {
                    throw new IllegalArgumentException("field name must be simple (firstName) or compound (user.firstName, account.user.firstName; cannot being or end with '.' (dot)");
                }
                this.fieldName = name.substring(lastDot + 1);
                this.prefixedFieldName = name;
            }
        }
    }
}

