/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.concurrent;

import com.google.common.annotations.Beta;
import java.io.Closeable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class AutoDrainingCounter
implements Closeable {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(AutoDrainingCounter.class);
    @Generated
    private final Object $lock = new Object[0];
    private final AtomicInteger count = new AtomicInteger();
    private final Duration drainPeriod;
    private final IntConsumer drainCallback;
    private final ScheduledExecutorService scheduledExecutor;
    private final AtomicBoolean counting;

    public AutoDrainingCounter(Duration drainPeriod) {
        this(drainPeriod, null);
    }

    public AutoDrainingCounter(Duration drainPeriod, @Nullable IntConsumer drainCallback) {
        this.drainPeriod = drainPeriod;
        this.drainCallback = drainCallback;
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        this.counting = new AtomicBoolean();
    }

    public static AutoDrainingCounter createAndStart(Duration drainPeriod) {
        return AutoDrainingCounter.createAndStart(drainPeriod, null);
    }

    public static AutoDrainingCounter createAndStart(Duration drainPeriod, @Nullable IntConsumer drainCallback) {
        AutoDrainingCounter counter = new AutoDrainingCounter(drainPeriod, drainCallback);
        counter.start();
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.counting.get()) {
                throw new IllegalStateException("counter already started");
            }
            long periodMillis = this.drainPeriod.toMillis();
            this.scheduledExecutor.scheduleWithFixedDelay(this::drain, periodMillis, periodMillis, TimeUnit.MILLISECONDS);
            this.counting.set(true);
        }
    }

    private void drain() {
        int oldCount = this.count.getAndSet(0);
        if (Objects.nonNull(this.drainCallback)) {
            this.drainCallback.accept(oldCount);
        }
        LOG.trace("Drained counter. Old count was: {}", (Object)oldCount);
    }

    public boolean isAlive() {
        return this.counting.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.isAlive()) {
                LOG.warn("Counter is not alive; ignoring request to stop");
                return;
            }
            this.counting.set(false);
            this.scheduledExecutor.shutdownNow();
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    public int get() {
        return this.count.get();
    }

    public int getAndIncrement() {
        return this.count.getAndIncrement();
    }

    public int incrementAndGet() {
        return this.count.incrementAndGet();
    }
}

