/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base.process;

import com.google.common.annotations.Beta;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.base.process.ProcessHelper;
import org.kiwiproject.base.process.Processes;
import org.kiwiproject.beta.base.process.ProcessResult;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.io.KiwiIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class ProcessHelpers {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(ProcessHelpers.class);
    private static final int DEFAULT_TIMEOUT_MILLIS = 5000;

    public static ProcessResult execute(ProcessHelper processHelper, List<String> command) {
        return ProcessHelpers.execute(processHelper, command, 5000L, TimeUnit.MILLISECONDS);
    }

    public static ProcessResult execute(ProcessHelper processHelper, List<String> command, Duration timeout) {
        long timeoutNanos = timeout.toNanos();
        return ProcessHelpers.execute(processHelper, command, timeoutNanos, TimeUnit.NANOSECONDS);
    }

    public static ProcessResult execute(ProcessHelper processHelper, List<String> command, long timeout, TimeUnit timeoutUnit) {
        int timeoutMillis = Ints.checkedCast((long)timeoutUnit.toMillis(timeout));
        return ProcessHelpers.tryExecute(processHelper, command, timeoutMillis);
    }

    private static ProcessResult tryExecute(ProcessHelper processHelper, List<String> command, int timeoutMillis) {
        try {
            LOG.trace("Executing command with timeout of {} millis: {}", (Object)timeoutMillis, command);
            return CompletableFuture.supplyAsync(() -> ProcessHelpers.executeSync(processHelper, command, timeoutMillis)).get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Interrupted while executing command with timeout {} millis: {}", new Object[]{timeoutMillis, command, e});
            return ProcessHelpers.processResultFromException(e, timeoutMillis);
        }
        catch (Exception e) {
            LOG.error("{} while executing command with timeout {} millis: {}", new Object[]{e.getClass().getSimpleName(), timeoutMillis, command, e});
            return ProcessHelpers.processResultFromException(e, timeoutMillis);
        }
    }

    private static ProcessResult executeSync(ProcessHelper processHelper, List<String> command, int timeoutMillis) {
        Process process = processHelper.launch(command);
        List stdOut = KiwiIO.readLinesFromInputStreamOf((Process)process);
        List stdErr = KiwiIO.readLinesFromErrorStreamOf((Process)process);
        Optional exitCodeOptional = processHelper.waitForExit(process, (long)timeoutMillis, TimeUnit.MILLISECONDS);
        return ProcessResult.builder().exitCode(exitCodeOptional.orElse(null)).timedOut(exitCodeOptional.isEmpty()).timeoutThresholdMillis(timeoutMillis).stdOutLines(stdOut).stdErrLines(stdErr).build();
    }

    private static ProcessResult processResultFromException(Exception ex, int timeoutMillis) {
        boolean timedOut = ex instanceof TimeoutException;
        Throwable error = ex instanceof ExecutionException ? ex.getCause() : ex;
        return ProcessResult.builder().error(error).timedOut(timedOut).timeoutThresholdMillis(timeoutMillis).stdOutLines(List.of()).stdErrLines(List.of()).build();
    }

    public static Process launchCommand(String command) {
        return ProcessHelpers.launchCommand(null, command);
    }

    public static Process launchCommand(@Nullable File workingDirectory, String command) {
        KiwiPreconditions.checkArgumentNotBlank((String)command, (String)"command must not be blank");
        List commandList = KiwiStrings.splitToList((CharSequence)command);
        return Processes.launch((File)workingDirectory, (List)commandList);
    }

    public static Process launchPipelineCommand(String pipeline) {
        return ProcessHelpers.launchPipelineCommand(null, pipeline);
    }

    public static Process launchPipelineCommand(@Nullable File workingDirectory, String pipeline) {
        KiwiPreconditions.checkArgumentNotBlank((String)pipeline, (String)"pipeline must not be blank");
        List<List<String>> pipelineCommands = KiwiStrings.splitToList((CharSequence)pipeline, (char)'|').stream().map(KiwiStrings::splitToList).toList();
        return ProcessHelpers.launchPipeline(workingDirectory, pipelineCommands);
    }

    public static Process launchPipeline(List<List<String>> commands) {
        return ProcessHelpers.launchPipeline(null, commands);
    }

    public static Process launchPipeline(@Nullable File workingDirectory, List<List<String>> commands) {
        KiwiPreconditions.checkArgumentNotEmpty(commands, (String)"commands must not be empty");
        List<ProcessBuilder> procBuilders = commands.stream().filter(KiwiLists::isNotNullOrEmpty).map(command -> new ProcessBuilder((List<String>)command).directory(workingDirectory)).toList();
        try {
            List<Process> procs = ProcessBuilder.startPipeline(procBuilders);
            return (Process)KiwiLists.last(procs);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Generated
    private ProcessHelpers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

