/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.util.function;

import com.google.common.annotations.Beta;
import java.util.function.Predicate;
import org.checkerframework.checker.index.qual.NonNegative;
import org.kiwiproject.base.KiwiPreconditions;

@Beta
public class CountingPredicate<T>
implements Predicate<T> {
    private final Predicate<T> predicate;
    private long trueCount;
    private long falseCount;

    public CountingPredicate(Predicate<T> predicate) {
        this.predicate = (Predicate)KiwiPreconditions.requireNotNull(predicate);
    }

    @Override
    public boolean test(T t) {
        boolean result = this.predicate.test(t);
        if (result) {
            ++this.trueCount;
        } else {
            ++this.falseCount;
        }
        return result;
    }

    public @NonNegative long trueCount() {
        return this.trueCount;
    }

    public @NonNegative long falseCount() {
        return this.falseCount;
    }
}

