/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base.jar;

import com.google.common.annotations.Beta;
import com.google.errorprone.annotations.CheckReturnValue;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.kiwiproject.beta.base.jar.AttributeLookupResult;
import org.kiwiproject.beta.base.jar.AttributeLookupStatus;
import org.kiwiproject.beta.base.jar.AttributesLookupResult;
import org.kiwiproject.beta.base.jar.AttributesLookupStatus;
import org.kiwiproject.beta.base.jar.JarManifests;
import org.kiwiproject.beta.base.jar.ManifestLookupResult;
import org.kiwiproject.beta.base.jar.ManifestLookupStatus;

@Beta
public class JarManifestHelper {
    @CheckReturnValue
    public AttributeLookupResult getMainAttributeValue(Class<?> theClass, String name) {
        try {
            Manifest manifest = JarManifests.getManifestOrThrow(theClass);
            return this.getMainAttributeValue(manifest, name);
        }
        catch (Exception e) {
            return new AttributeLookupResult(AttributeLookupStatus.FAILURE, null, e);
        }
    }

    @CheckReturnValue
    public AttributeLookupResult getMainAttributeValue(Manifest manifest, String name) {
        Attributes attributes = manifest.getMainAttributes();
        if (!attributes.containsKey(new Attributes.Name(name))) {
            return new AttributeLookupResult(AttributeLookupStatus.DOES_NOT_EXIST, null, null);
        }
        String value = attributes.getValue(name);
        return new AttributeLookupResult(AttributeLookupStatus.EXISTS, value, null);
    }

    public AttributesLookupResult getMainAttributes(Class<?> theClass) {
        ManifestLookupResult lookupResult = this.getManifestWithResult(theClass);
        return switch (lookupResult.lookupStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case ManifestLookupStatus.SUCCESS -> {
                Map<String, String> mainAttributes = this.getMainAttributes(lookupResult.manifestOrThrow());
                yield new AttributesLookupResult(AttributesLookupStatus.SUCCESS, mainAttributes, null);
            }
            case ManifestLookupStatus.FAILURE -> new AttributesLookupResult(AttributesLookupStatus.FAILURE, null, lookupResult.error());
        };
    }

    public Map<String, String> getMainAttributes(Manifest manifest) {
        return JarManifests.getMainAttributesAsMap(manifest);
    }

    public Optional<Manifest> getManifest(Class<?> theClass) {
        return JarManifests.getManifest(theClass);
    }

    public ManifestLookupResult getManifestWithResult(Class<?> theClass) {
        JarManifests.ClassHolder classHolder = new JarManifests.ClassHolder(theClass);
        return JarManifests.getManifest(classHolder);
    }

    public Optional<Manifest> getManifest(URI jarFileURI) {
        return JarManifests.getManifest(jarFileURI);
    }

    public ManifestLookupResult getManifestWithResult(URI jarFileURI) {
        return JarManifests.getManifestWithResult(jarFileURI);
    }
}

