/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base.jar;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.beta.base.jar.AttributesLookupStatus;

public record AttributesLookupResult(AttributesLookupStatus lookupStatus, @Nullable Map<String, String> attributes, @Nullable Exception error) {
    public AttributesLookupResult(AttributesLookupStatus lookupStatus, @Nullable Map<String, String> attributes, @Nullable Exception error) {
        if (lookupStatus == AttributesLookupStatus.SUCCESS) {
            KiwiPreconditions.checkArgumentNotNull(attributes, (String)"attributes must not be null when lookup succeeds");
            KiwiPreconditions.checkArgumentIsNull((Object)error, (String)"error must be null when lookup succeeds");
        } else {
            KiwiPreconditions.checkArgumentIsNull(attributes, (String)"attributes must be null when lookup fails");
        }
    }

    public boolean failed() {
        return !this.succeeded();
    }

    public boolean succeeded() {
        return this.lookupStatus == AttributesLookupStatus.SUCCESS;
    }

    public boolean hasAttributes() {
        return Objects.nonNull(this.attributes);
    }

    public Optional<Map<String, String>> maybeAttributes() {
        return Optional.ofNullable(this.attributes);
    }
}

