/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.health;

import com.codahale.metrics.Meter;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.annotations.Beta;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.kiwiproject.beta.metrics.NamedMeter;
import org.kiwiproject.metrics.health.HealthCheckResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SimpleMeterHealthCheck
extends HealthCheck {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(SimpleMeterHealthCheck.class);
    private static final String HEALTHY_MESSAGE = "No errors in the last 15 minutes";
    private static final String UNHEALTHY_MESSAGE = "Some errors in the last 15 minutes";
    private static final long NUM_SECONDS_IN_15_MINUTES = TimeUnit.MINUTES.toSeconds(15L);
    private final NamedMeter meter;

    public SimpleMeterHealthCheck(String name, Meter meter) {
        this.meter = NamedMeter.of(name, meter);
    }

    protected HealthCheck.Result check() {
        if (SimpleMeterHealthCheck.hasAnyErrorsInLast15Minutes(this.meter)) {
            return HealthCheckResults.newUnhealthyResult((String)UNHEALTHY_MESSAGE);
        }
        return HealthCheckResults.newHealthyResult((String)HEALTHY_MESSAGE);
    }

    private static boolean hasAnyErrorsInLast15Minutes(NamedMeter meter) {
        double fifteenMinuteRate = meter.getFifteenMinuteRate();
        double estimatedErrorCount = fifteenMinuteRate * (double)NUM_SECONDS_IN_15_MINUTES;
        LOG.trace("Meter {}: 15 minute rate : {} , estimated error count: {}", new Object[]{meter.getName(), fifteenMinuteRate, estimatedErrorCount});
        return estimatedErrorCount >= 1.0;
    }
}

