/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base;

import com.google.common.annotations.Beta;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;

@Beta
public class TypeMismatchException
extends RuntimeException {
    private final Class<?> expectedType;
    private final Class<?> actualType;

    private TypeMismatchException(String message, Class<?> expectedType, Class<?> actualType, Throwable cause) {
        super(message, cause);
        this.expectedType = (Class)KiwiPreconditions.requireNotNull(expectedType, (String)"expectedType must not be null", (Object[])new Object[0]);
        this.actualType = (Class)KiwiPreconditions.requireNotNull(actualType, (String)"actualType must not be null", (Object[])new Object[0]);
    }

    public Class<?> expectedType() {
        return this.expectedType;
    }

    public Class<?> actualType() {
        return this.actualType;
    }

    public static TypeMismatchException forUnexpectedType(Class<?> expectedType, Class<?> actualType) {
        String message = KiwiStrings.f((String)"Cannot cast value of type {} to type {}", (Object[])new Object[]{actualType.getName(), expectedType.getName()});
        return TypeMismatchException.forUnexpectedTypeWithMessage(message, expectedType, actualType, null);
    }

    public static TypeMismatchException forUnexpectedTypeWithCause(Class<?> expectedType, Class<?> actualType, ClassCastException cause) {
        String message = KiwiStrings.f((String)"Cannot cast value of type {} to type {}", (Object[])new Object[]{actualType.getName(), expectedType.getName()});
        return TypeMismatchException.forUnexpectedTypeWithMessage(message, expectedType, actualType, cause);
    }

    public static TypeMismatchException forUnexpectedCollectionElementType(Class<?> collectionType, Class<?> expectedType, Class<?> actualType) {
        String message = KiwiStrings.f((String)"Expected {} to contain elements of type {}, but found element of type {}", (Object[])new Object[]{collectionType.getName(), expectedType.getName(), actualType.getName()});
        return TypeMismatchException.forUnexpectedTypeWithMessage(message, expectedType, actualType, null);
    }

    public static TypeMismatchException forUnexpectedMapKeyType(Class<?> expectedKeyType, Class<?> actualKeyType) {
        String message = KiwiStrings.f((String)"Expected Map to contain keys of type {}, but found key of type {}", (Object[])new Object[]{expectedKeyType.getName(), actualKeyType.getName()});
        return TypeMismatchException.forUnexpectedTypeWithMessage(message, expectedKeyType, actualKeyType, null);
    }

    public static TypeMismatchException forUnexpectedMapValueType(Class<?> expectedValueType, Class<?> actualValueType) {
        String message = KiwiStrings.f((String)"Expected Map to contain values of type {}, but found value of type {}", (Object[])new Object[]{expectedValueType.getName(), actualValueType.getName()});
        return TypeMismatchException.forUnexpectedTypeWithMessage(message, expectedValueType, actualValueType, null);
    }

    public static TypeMismatchException forUnexpectedTypeWithMessage(String message, Class<?> expectedType, Class<?> actualType, ClassCastException cause) {
        return new TypeMismatchException(message, expectedType, actualType, cause);
    }
}

