/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.reflect;

import com.google.common.annotations.Beta;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.beta.reflect.TypeInfo;

@Beta
public final class KiwiReflection2 {
    public static boolean hasAccessModifier(Member member, JavaAccessModifier modifier) {
        return switch (modifier) {
            default -> throw new IncompatibleClassChangeError();
            case JavaAccessModifier.PUBLIC -> KiwiReflection2.isPublic(member);
            case JavaAccessModifier.PROTECTED -> KiwiReflection2.isProtected(member);
            case JavaAccessModifier.PRIVATE -> KiwiReflection2.isPrivate(member);
            case JavaAccessModifier.PACKAGE_PRIVATE -> KiwiReflection2.isPackagePrivate(member);
        };
    }

    public static boolean hasAccessModifier(Class<?> clazz, JavaAccessModifier modifier) {
        return switch (modifier) {
            default -> throw new IncompatibleClassChangeError();
            case JavaAccessModifier.PUBLIC -> KiwiReflection2.isPublic(clazz);
            case JavaAccessModifier.PROTECTED -> KiwiReflection2.isProtected(clazz);
            case JavaAccessModifier.PRIVATE -> KiwiReflection2.isPrivate(clazz);
            case JavaAccessModifier.PACKAGE_PRIVATE -> KiwiReflection2.isPackagePrivate(clazz);
        };
    }

    public static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isProtected(Member member) {
        return Modifier.isProtected(member.getModifiers());
    }

    public static boolean isProtected(Class<?> clazz) {
        return Modifier.isProtected(clazz.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isPrivate(Class<?> clazz) {
        return Modifier.isPrivate(clazz.getModifiers());
    }

    public static boolean isPackagePrivate(Member member) {
        return !KiwiReflection2.isPublic(member) && !KiwiReflection2.isProtected(member) && !KiwiReflection2.isPrivate(member);
    }

    public static boolean isPackagePrivate(Class<?> clazz) {
        return !KiwiReflection2.isPublic(clazz) && !KiwiReflection2.isProtected(clazz) && !KiwiReflection2.isPrivate(clazz);
    }

    public static TypeInfo typeInformationOf(@NonNull Field field) {
        KiwiPreconditions.checkArgumentNotNull((Object)field, (String)"field to inspect must not be null");
        Type genericType = field.getGenericType();
        return KiwiReflection2.typeInformationOf(genericType);
    }

    public static TypeInfo typeInformationOf(@NonNull Type type) {
        return TypeInfo.ofType(type);
    }

    @Generated
    private KiwiReflection2() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum JavaAccessModifier {
        PUBLIC,
        PROTECTED,
        PRIVATE,
        PACKAGE_PRIVATE;

    }
}

