/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.xml.ws.soap;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import jakarta.xml.soap.Detail;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiMaps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class SOAPFaults {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(SOAPFaults.class);
    public static final String UNSUPPORTED = "UNSUPPORTED";

    public static boolean logSoapFaultIfPresent(String context, @Nullable Throwable throwable, Logger logger) {
        String contextOrUnspecified = SOAPFaults.contextOrUnspecified(context);
        try {
            int index = ExceptionUtils.indexOfType((Throwable)throwable, SOAPFaultException.class);
            if (index == -1) {
                return false;
            }
            Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)throwable);
            SOAPFaultException soapFaultException = (SOAPFaultException)throwables[index];
            SOAPFaults.logSoapFault(contextOrUnspecified, soapFaultException, logger);
        }
        catch (Exception e) {
            LOG.error("[{}] Error logging information about SOAPFault", (Object)contextOrUnspecified, (Object)e);
        }
        return true;
    }

    public static void logSoapFault(String context, SOAPFaultException exception, Logger logger) {
        KiwiPreconditions.checkArgumentNotNull((Object)exception);
        SOAPFaults.logSoapFault(context, exception.getFault(), logger);
    }

    public static void logSoapFault(String context, SOAPFault fault, Logger logger) {
        KiwiPreconditions.checkArgumentNotNull((Object)fault);
        KiwiPreconditions.checkArgumentNotNull((Object)logger);
        String contextOrUnspecified = SOAPFaults.contextOrUnspecified(context);
        try {
            Map<String, Object> faultInfo = SOAPFaults.soapFaultAsMap(fault);
            logger.error("[{}] SOAPFault: {}", (Object)contextOrUnspecified, faultInfo);
        }
        catch (Exception e) {
            LOG.error("[{}] Error logging information about SOAPFault", (Object)contextOrUnspecified, (Object)e);
        }
    }

    private static String contextOrUnspecified(String context) {
        return StringUtils.isBlank((CharSequence)context) ? "unspecified" : context;
    }

    public static Map<String, Object> soapFaultAsMap(SOAPFault fault) {
        KiwiPreconditions.checkArgumentNotNull((Object)fault);
        String faultCode = fault.getFaultCode();
        String faultString = fault.getFaultString();
        String faultActor = fault.getFaultActor();
        String faultRole = SOAPFaults.getFaultRole(fault);
        List<String> faultReasonTexts = SOAPFaults.getReasonTexts(fault, "[Unable to get faultReasonTexts]");
        List<String> faultSubcodes = SOAPFaults.getFaultSubcodes(fault);
        List<String> details = SOAPFaults.getDetailsAsStrings(fault, "[Unable to get fault Detail information]");
        return KiwiMaps.newLinkedHashMap((Object[])new Object[]{"faultCode", faultCode, "faultString", faultString, "faultActor", faultActor, "faultRole", faultRole, "faultReasonTexts", faultReasonTexts, "faultSubcodes", faultSubcodes, "details", details});
    }

    private static String getFaultRole(SOAPFault fault) {
        try {
            return fault.getFaultRole();
        }
        catch (UnsupportedOperationException unsupportedEx) {
            LOG.debug("faultRole is not supported");
            LOG.trace("faultRole unsupported stack trace:", (Throwable)unsupportedEx);
            return UNSUPPORTED;
        }
    }

    @VisibleForTesting
    static List<String> getReasonTexts(SOAPFault fault, String errorText) {
        try {
            Iterator faultReasonTexts = fault.getFaultReasonTexts();
            return Streams.stream((Iterator)faultReasonTexts).toList();
        }
        catch (UnsupportedOperationException unsupportedEx) {
            LOG.debug("faultReasonTexts is not supported");
            LOG.trace("faultReasonTexts unsupported stack trace:", (Throwable)unsupportedEx);
            return List.of(UNSUPPORTED);
        }
        catch (Exception e) {
            LOG.error("Error getting faultReasonTexts", (Throwable)e);
            return List.of(errorText);
        }
    }

    @VisibleForTesting
    static List<String> getFaultSubcodes(SOAPFault fault) {
        try {
            return Streams.stream((Iterator)fault.getFaultSubcodes()).map(QName::toString).toList();
        }
        catch (UnsupportedOperationException unsupportedEx) {
            LOG.debug("faultSubcodes is not supported");
            LOG.trace("faultSubcodes unsupported stack trace:", (Throwable)unsupportedEx);
            return List.of(UNSUPPORTED);
        }
    }

    @VisibleForTesting
    static List<String> getDetailsAsStrings(SOAPFault fault, String errorText) {
        try {
            Detail detail = fault.getDetail();
            if (Objects.isNull(detail)) {
                return List.of();
            }
            Iterator detailEntries = detail.getDetailEntries();
            return Streams.stream((Iterator)detailEntries).map(detailEntry -> {
                String nodeName = detailEntry.getNodeName();
                String nodeValue = detailEntry.getNodeValue();
                return nodeName + " = " + nodeValue;
            }).toList();
        }
        catch (Exception e) {
            LOG.warn("Error getting fault Detail information", (Throwable)e);
            return List.of(errorText);
        }
    }

    @Generated
    private SOAPFaults() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

