/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.net;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.net.MediaType;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;

@Beta
public final class KiwiMediaTypes {
    private static final String APPLICATION_TYPE = "application";
    private static final String TEXT_TYPE = "text";
    private static final Set<String> XML_TYPES = Set.of("text", "application");
    private static final String JSON_SUBTYPE = "json";
    private static final String PLAIN_SUBTYPE = "plain";
    private static final String XML_SUBTYPE = "xml";
    private static final String HTML_SUBTYPE = "html";

    public static boolean isXml(jakarta.ws.rs.core.MediaType mediaType) {
        KiwiMediaTypes.checkJakartaMediaType(mediaType);
        return KiwiMediaTypes.isXml(mediaType.toString());
    }

    public static boolean isXml(String mediaType) {
        return KiwiMediaTypes.matchesTypeAndSubtype(mediaType, XML_TYPES, XML_SUBTYPE);
    }

    public static boolean isHtml(jakarta.ws.rs.core.MediaType mediaType) {
        KiwiMediaTypes.checkJakartaMediaType(mediaType);
        return KiwiMediaTypes.isHtml(mediaType.toString());
    }

    public static boolean isHtml(String mediaType) {
        return KiwiMediaTypes.matchesTypeAndSubtype(mediaType, TEXT_TYPE, HTML_SUBTYPE);
    }

    public static boolean isJson(jakarta.ws.rs.core.MediaType mediaType) {
        KiwiMediaTypes.checkJakartaMediaType(mediaType);
        return KiwiMediaTypes.isJson(mediaType.toString());
    }

    public static boolean isJson(String mediaType) {
        return KiwiMediaTypes.matchesTypeAndSubtype(mediaType, APPLICATION_TYPE, JSON_SUBTYPE);
    }

    public static boolean isPlainText(jakarta.ws.rs.core.MediaType mediaType) {
        KiwiMediaTypes.checkJakartaMediaType(mediaType);
        return KiwiMediaTypes.isPlainText(mediaType.toString());
    }

    public static boolean isPlainText(String mediaType) {
        return KiwiMediaTypes.matchesTypeAndSubtype(mediaType, TEXT_TYPE, PLAIN_SUBTYPE);
    }

    public static String toStringWithoutParameters(jakarta.ws.rs.core.MediaType mediaType) {
        KiwiMediaTypes.checkJakartaMediaType(mediaType);
        return KiwiStrings.f((String)"{}/{}", (Object[])new Object[]{mediaType.getType(), mediaType.getSubtype()});
    }

    public static String withoutParameters(String mediaType) {
        KiwiMediaTypes.checkMediaTypeNotBlank(mediaType);
        return MediaType.parse((String)mediaType).withoutParameters().toString();
    }

    public static boolean matchesType(String mediaType, String typeToMatch) {
        KiwiMediaTypes.checkMediaTypeNotBlank(mediaType);
        KiwiMediaTypes.checkMediaTypeNotBlank(typeToMatch, "typeToMatch");
        MediaType parsedType = MediaType.parse((String)mediaType);
        String type = parsedType.type();
        return typeToMatch.equals(type);
    }

    public static boolean matchesSubtype(String mediaType, String subtypeToMatch) {
        KiwiMediaTypes.checkMediaTypeNotBlank(mediaType);
        KiwiMediaTypes.checkMediaTypeNotBlank(subtypeToMatch, "subtypeToMatch");
        MediaType parsedType = MediaType.parse((String)mediaType);
        String subtype = parsedType.subtype();
        return subtypeToMatch.equals(subtype);
    }

    public static boolean matchesMediaType(jakarta.ws.rs.core.MediaType mediaType, String mediaTypeToMatch) {
        KiwiMediaTypes.checkJakartaMediaType(mediaType);
        return KiwiMediaTypes.matchesMediaType(mediaType.toString(), mediaTypeToMatch);
    }

    public static boolean matchesMediaType(jakarta.ws.rs.core.MediaType mediaType, jakarta.ws.rs.core.MediaType mediaTypeToMatch) {
        KiwiMediaTypes.checkJakartaMediaType(mediaType);
        KiwiMediaTypes.checkJakartaMediaType(mediaTypeToMatch, "mediaTypeToMatch");
        return KiwiMediaTypes.matchesMediaType(mediaType.toString(), mediaTypeToMatch.toString());
    }

    public static boolean matchesMediaType(String mediaType, String mediaTypeToMatch) {
        KiwiMediaTypes.checkMediaTypeNotBlank(mediaType);
        KiwiMediaTypes.checkMediaTypeNotBlank(mediaTypeToMatch, "mediaTypeToMatch");
        int slashIndex = StringUtils.indexOf((CharSequence)mediaTypeToMatch, (int)47);
        Preconditions.checkArgument((slashIndex > -1 && !StringUtils.contains((CharSequence)mediaTypeToMatch, (int)59) ? 1 : 0) != 0, (Object)"mediaTypeToMatch must not be blank and be in the format type/subtype");
        String type = mediaTypeToMatch.substring(0, slashIndex);
        String subtype = mediaTypeToMatch.substring(slashIndex + 1);
        return KiwiMediaTypes.matchesTypeAndSubtype(mediaType, type, subtype);
    }

    public static boolean matchesTypeAndSubtype(jakarta.ws.rs.core.MediaType mediaType, String typeToMatch, String subtypeToMatch) {
        KiwiMediaTypes.checkJakartaMediaType(mediaType);
        return KiwiMediaTypes.matchesTypeAndSubtype(mediaType.toString(), typeToMatch, subtypeToMatch);
    }

    public static boolean matchesTypeAndSubtype(String mediaType, String typeToMatch, String subtypeToMatch) {
        KiwiPreconditions.checkArgumentNotBlank((String)typeToMatch, (String)"typeToMatch must not be blank");
        return KiwiMediaTypes.matchesTypeAndSubtype(mediaType, Set.of(typeToMatch), subtypeToMatch);
    }

    public static boolean matchesTypeAndSubtype(jakarta.ws.rs.core.MediaType mediaType, Set<String> typesToMatch, String subtypeToMatch) {
        KiwiMediaTypes.checkJakartaMediaType(mediaType);
        return KiwiMediaTypes.matchesTypeAndSubtype(mediaType.toString(), typesToMatch, subtypeToMatch);
    }

    private static void checkJakartaMediaType(jakarta.ws.rs.core.MediaType mediaType) {
        KiwiMediaTypes.checkJakartaMediaType(mediaType, "mediaType");
    }

    private static void checkJakartaMediaType(jakarta.ws.rs.core.MediaType mediaType, String argumentName) {
        KiwiPreconditions.checkArgumentNotNull((Object)mediaType, (String)"%s must not be null", (Object[])new Object[]{argumentName});
    }

    public static boolean matchesTypeAndSubtype(String mediaType, Set<String> typesToMatch, String subtypeToMatch) {
        KiwiMediaTypes.checkMediaTypeNotBlank(mediaType);
        KiwiPreconditions.checkArgumentNotEmpty(typesToMatch, (String)"typesToMatch must not be empty");
        boolean anyBlank = typesToMatch.stream().anyMatch(StringUtils::isBlank);
        Preconditions.checkArgument((!anyBlank ? 1 : 0) != 0, (Object)"typesToMatch must not contain blank elements");
        KiwiPreconditions.checkArgumentNotBlank((String)subtypeToMatch, (String)"subtypeToMatch must not be blank");
        MediaType parsedType = MediaType.parse((String)mediaType);
        String type = parsedType.type();
        String subtype = parsedType.subtype();
        return typesToMatch.contains(type) && subtypeToMatch.equals(subtype);
    }

    private static void checkMediaTypeNotBlank(String mediaType) {
        KiwiMediaTypes.checkMediaTypeNotBlank(mediaType, "mediaType");
    }

    private static void checkMediaTypeNotBlank(String mediaType, String argumentName) {
        KiwiPreconditions.checkArgumentNotBlank((String)mediaType, (String)"%s must not be blank", (Object[])new Object[]{argumentName});
    }

    @Generated
    private KiwiMediaTypes() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

